
## 4.1. Analysis

Previously we assumed the training data (observed plans) Φ was sampled
(i.i.d.) directly from the user's true preference distribution (say U):

$$P(\Phi\mid{\mathcal{U}})=\prod P(\phi\mid{\mathcal{U}}).$$
φ∈Φ
But now we assume that varying feasibility constraints intervene. For the sake of notation, imagine that such variation is in the form of a distribution, say F,
over planning problems (but all that is actually required is that the variation is independent of preferences, as assumed below). Note that a planning problem is logically equivalent to its solution set. Then we can write P(F | F) to denote the prior probability of any particular set of solutions F. Since the user chooses among such solutions, we have that chosen plans are sampled from the posterior, over solutions, of the preference distribution:

$$P(\Phi\mid{\mathcal{U}},{\mathcal{F}})=\prod_{(\phi,F)\in\Phi}P(\phi\mid{\mathcal{U}},F)\cdot P(F\mid{\mathcal{F}}).$$

We assume that preferences and feasibility constraints are mutually independent: what is possible does not depend upon desire, and desire does not depend upon what is possible. One can certainly imagine either dependence - respectively Murphy's Law (or its complement) and the fox in Aesop's fable of Sour Grapes
(or envy) - but it seems to us more reasonable to assume independence. Then we can rewrite the posterior of the preference distribution:

$$P(\Phi\mid{\mathcal{U}},{\mathcal{F}})=\prod_{(\phi,F)\in\Phi}{\frac{P(\phi\mid{\mathcal{U}})}{\sum_{\phi^{\prime}\in F}P(\phi^{\prime}\mid{\mathcal{U}})}}\cdot P(F\mid{\mathcal{F}})\qquad{\mathrm{(by~assumption).}}$$

Anyways assuming independence is important, because it makes the preference learning problem attackable. In particular, the posteriors preserve relative preferences - for all **φ, φ**′ ∈ F, the *odds* of selecting φ over φ
′are:

$$\begin{array}{l}{{O(\phi,\phi^{\prime}):=\frac{P(\phi\mid\mathcal{U},F)}{P(\phi^{\prime}\mid\mathcal{U},F)},}}\\ {{=\frac{P(\phi\mid\mathcal{U})}{\sum_{\phi^{\prime\prime}\in F}P(\phi^{\prime\prime}\mid\mathcal{U})}\div\frac{P(\phi^{\prime}\mid\mathcal{U})}{\sum_{\phi^{\prime\prime}\in F}P(\phi^{\prime\prime}\mid\mathcal{U})},}}\\ {{=\frac{P(\phi\mid\mathcal{U})}{P(\phi^{\prime}\mid\mathcal{U})}.}}\end{array}$$

18