
## 4.2. Rescaling

Output. The result of rescaling is a set of clusters of weighted plans, C =
{c1, c2**, . . . , c**n}. Each cluster, c ∈ C, consists of a set of plans with associated weights; we write p ∈ c for membership and wc(p) for the associated weight.

Clustering. First we collapse all of the input records from the same or similar situations into single weighted clusters, with one count going towards each instance of an observed plan participating in the collapse. For example, suppose we observe 3 instances of *Gobyplane* chosen in preference to *Gobytrain* and 1 instance of the reverse in similar or identical situations. Then we will end up with a cluster with weights 3 and 1 for *Gobyplane* and *Gobytrain* respectively. In other words wc(p) is the number of times p was chosen by the user in the set of situations collapsing to c (or ǫ if p was never chosen). This happens in lines 2–2 of Algorithm 2, which also defines 'similar' (as set inclusion). Future work should consider more sophisticated clustering methods.

Transitive Closure. Next we make indirect inferences between clusters; this happens by iteratively merging clusters with non-empty intersections. Consider two clusters, c and d, in the Travel domain. Say d contains *Gobyplane* and *Gobytrain* with counts 3 and 1 respectively, and c contains *Gobytrain* and *Gobybike* with counts 5 and 1 respectively. From this we infer that *Gobyplane* would be executed 15 times more frequently than *Gobybike* in a situation where all 3 plans (Gobyplane, *Gobytrain*, and *Gobybike*) are possible, since it is executed 3 times more frequently than *Gobytrain* which is in turn executed 5 times more frequently than Gobybike. We represent this inference by scaling one of the clusters so that the shared plan has the same weight, and then take the union. In the example, supposing we merge d into c, then we scale d so that c ∩ d = {Gobytrain} has the same weight in both c and d, i.e. we scale d by 5 = wc(Gobytrain)
wd(Gobytrain)
. For pairs of clusters with more than one shared plan we scale d \ c by the average of wc(·)
wd(·)
for each plan in the intersection, but we leave the weights of c ∩ d as in c (one could consider several alternative strategies for plans in the intersection). Computing the scaling factor happens in lines 2–2 and the entire merging process happens in lines 2–2 of Algorithm 2.

4.3. Learning We learn a set of pHTNs for C by applying the base learner (with the obvious generalization to weighted input) to each c ∈ C:

$$\mathbf{H}=\{H_{c}=\mathbf{EM}(\mathbf{SH}(c))\mid c\in C\}.$$
H = {Hc = EM(SH(c)) | c ∈ C}. (14)
$$(14)^{\frac{1}{2}}$$
