
## 5. Discussion And Related Work

In the planning community, HTN planning has for a long time been given two distinct and sometimes conflicting interpretations (c.f. [3]): it can be interpreted either in terms of domain abstraction11 or in terms of expressing complex (not first order Markov) constraints on plans12. The original HTN planners were motivated by the former view (improving efficiency via abstraction). In this view, only top-down HTN planning makes sense as the HTN is supposed to express effective search control. Paradoxically, w.r.t. that motivation, the complexity of HTN planning is substantially worse than planning with just primitive actions [15]. The latter view explains the seeming paradox easily - finding a solution should be easier, in general, than finding one that also satisfies additional complex constraints.

From this perspective both top-down *and bottom-up* approaches to HTN planning are appropriate (the former if one is pessimistic concerning the satisfiability of the complex constraints, and the latter if one is optimistic). Indeed, this perspective lead to the development of bottom-up approaches [16].

Despite this dichotomy, most prior work on learning HTN models (e.g. [17, 18, 19, 20]) has focused only on the domain abstraction angle. Typical approaches here require the structure of the reduction schemas to be given as input, and focus on learning applicability conditions for the non-primitives. In contrast, our work focuses on learning HTNs as a way to capture user preferences, given only successful plan traces. The difference in focus also explains the difference in evaluation techniques. While most previous HTN learning efforts are evaluated in terms of how close the learned schemas and applicability conditions are, syntactically, to the actual model, we evaluate in terms of how close the distribution of plans generated by the learned model is to the distribution generated by the actual model.

An intriguing question is whether pHTNs learned to capture user preferences can, in the long run, be over-loaded with domain semantics. In particular, it would be interesting to combine the two HTN learning strands by sending our learned pHTNs as input to the method applicability condition learners. Presuming the user's preferences are amenable, the applicability conditions thus learned might then allow efficient top-down interpretation (of course, the user's preferences could, in light of the complexity results for HTN planning, be so antithetical to the nature of the domain that efficient top-down interpretation is impossible).