P. Werbos (1999), Neurocontrollers, in J. Webster, ed., *Encyclopedia of Electrical and Electronic Engineering*, Wiley. 

P.Werbos (2009), Intelligence in the Brain: A 
theory of how it works and how to build it, *Neural* Networks, Volume 22, Issue 3, April 2009, Pages 200-212.

## Appendix. Larger Context And Update To 2010

The research challenge described in this paper is really just one step along the way to a much larger goal - the ability to understand and replicate the highest level of intelligence which exists even in the brain of the mouse. On the one hand, this task is a simplified reduced form of the design task which I called "Stochastic Action Nets" in Werbos (1998b). On the other hand, this is a difficult enough task in itself. In the previous decade, I awarded NSF grants to Wunsch (neural traveling salesman), to Serpen (simultaneous recurrent networks for stochastic search) and to Pelikan to begin to address this kind of challenge; however, they did not really succeed in addressing it headon. 

On May 24, 2010, Michael Fu of the University of Maryland and Barry Nelson led a new workshop for NSF on Simulation Optimization, http://users.iems.northwestern.edu/~nelsonb/workshop/,
which revisited this topic. Russell Barton of Penn State University reviewed the work on "metamodels" or "forwards metamodels" -- the use of fast approximators to approximate the function U(u,α) as a function of u, to assist in stochastic search across values of u. He also mentioned his recent work in "inverse metamodeling" aimed at finding a metamodel to output a value of u which would meet some target outcome.

Even by 1998, Thaler had already had great success in stochastic search by training a classic kind of neural network (multilayer perceptron MLP gtrained by backpropagation) to serve as a "forwards global metamodel," a model of U across the entire space of possible choices u. In the 2010 workshop, Barton noted that more researchers have been working with "local metamodels," metamodels of small regions in u space, because of the difficulty of obtianing global models, and because local metamodels are good enough for exploring the immediate neighborhood of the best value of u found so far; however, purely local metamodels are not useful in the larger task of finding the region of space where the best solution may be found, if U is not a convex function of u. 

In this workshop, I observed how the BliSS 
formulation here allows the formulation of a different kind of inverse metamodel, one which tries to map from α to the optimal u for that α. 

In the breakout group led by Jeffrey Herrmann of the University of Maryland, we groped for notation that would be more compelling to the operations research community to express this idea. In that community, it is common to say we are trying to maximize or minimize f(x).

To extend that notation, we may say that BliSS tries to maximize f(x1,x2) as a function of x2. Or, as suggested by Hermann, we may use the letter "I" to denote an *instance* of the type of optimization problem we are trying to solve; in effect, "I" and x2" and "α" all represent the same idea.

It is exciting indeed that the research community may be ready to make a more serious effort to adress this kind of metamodeling. However, there is a key technical difficulty which needs to be addressed head-on. It is *easier* to learn local metamodels than to learn global metamodels, and it is easier to learn global metamodels than it is to learn inverse metamodels. There are two new technical challenges here: (1) how to choose a function approximator which is powerful enough to approximate a more challenging function (a function which is typically less smooth than the forwards function U and may involve many inputs over a large range of space); and (2) how to train the paramneters of that approximator, which may be challenging minimization problem in itself. 

These technical difficulties are merely a special case of the larger challenge of learning predictive relations from data, which is a key part of the computatonal intelligence community. I have posted a current review of the opportunities and challenges here at //www.werbos.com/Neural/Erdos_talk_Werbos_final.pdf. 

(Unfortunately the file is too large to fit with current rules at arXiv.) 
However, even a well trained inverse metamodel of this sort would still have some limitations. In many applications, one would not expect such an inverse metamodel to do as well as an expensive search dedicated to just one choice of α. However, such searches are usually very sensitive to their starting points. A trained inverse metamodel could be very useful in getting to the right area quickly, and in providing a "warm start" which reduces the time required to find the precise optimum. In some applications, the value of finding a good choice quickly may be greater than the value of finding the best choice over a long long time. With many neural network approximators, it is also possible to get full advantage of massively parallel chips such as Celular Neural Network chips, which allow even faster computation.

Once we start mastering such deterministic inverse metamodels, the next step up, closer to brain-like technology, is to build and use stochastic inverse metamodels, which learn to output new possibilities for u which have the best possible probability of finding a better choice than those now in hand, or which improve the quality of the metamodels now in hand.

That, in turn, is a step towards true Stochastic Action Networks. In Werbos (1998b), I stressed that there are really two types of "Action Network" in a complex, brain-like Approximate Adaptive Dynamic Programming 
(ADP) System. There are low-level action networks, which try to output vectors u(t) of current actions at time t. But there are also high-level action networks as part of 
"Decision Blocks," the kind of networks would address 