arbitrary choice of random program generator is not critical, since if there were a better random program generator, our random program generator would have some finite chance of generating it, and so we underestimate the probability of generating any program by at most that constant factor. It could be a large constant factor, but the larger our problems and the more evidence we have, the less significant that constant factor will be. Example 2: an unknown function f returns 9 when given 3 and 16 when given 4. What does f(5) return?

<random program generator>
evidence (f(3) == 9)
evidence (f(4) == 16)
print (f(5))
In this example, in order to give the evidence high probability, the random program generator will need to make choices that define f as some function which has a good chance of returning 9 when called with 3 and 16 when called with 4. 

When using a random program generator, there are, of course limitations on what the generated program can do. For instance, in the above example, the generated program is not allowed to redefine the evidence function or the equality operator, or to exit the model program early, or to read the values 9 and 16 out of the input program. The details of how to protect against this will depend on our choice of programming language.

Example 3: designing an agent to act in a known environment Our model represents a known environment which makes calls to an agent for a decision. The agent's decision function will be left up to a random program generator. There is evidence that the agent accomplishes a goal. For example, The environment could be "blocks world", chess versus a known program as an opponent, a traveling salesman problem, etc.

We end up reasoning about what likely algorithms will make the agent likely to accomplish its goal. In such a model, we may need to be careful not to allow the agent's decision function to read or modify parts of the environment that it is not allowed to. Again, how we do this is language dependent.

Example 4: explaining the hidden structure in any large data set.

<random program generator>
evidence(d == <our data set>)
The data set could be the text of wikipedia, the set of undeciphered Linear A inscriptions, Tycho Brahe's astronomical observations, the text of the web, etc. This is the problem that most excites us. In our opinion, it's a fundamental problem of science - trying to find the most likely generative explanation of the world. We hope that our inference system, when given a set of physical observations, will hypothesize the laws of physics in order to explain the observations in the most likely manner. 

Likewise, when asked to explain the text of the web, we hope that our system will hypothesize the existence of a physical universe and how it may have given rise to the text. 

## Inference

By "inference", we mean that we want to compute the expected value E(h(x)|e) of some hypothesis h which is a function of the execution path x of the model, given the evidence e. (If we want the probability of a binary predicate, we can represent that as the expected value of the 0/1 indicator function for that predicate).

(1) E(h(x)|e) = ΣxP(x|e) h(x) 
 = ΣxP(x) P(e|x) h(x) / P(e) = ΣxP(x) P(e|x) h(x) / ΣxP(x) P(e|x)
In general, this is utterly intractable to compute, requiring one to enumerate over all execution paths of the model.

As mentioned above, for a particular execution path x, P(x) 
and P(e|x) are easy to compute. P(e) and P(x|e) are hard to compute, since they appear to also require a complete enumeration.

To introduce a little notation, let's say that X is the set of execution paths PX is the prior probability distribution over execution paths. P(x) is synonymous with PX(x). PX|e is the posterior probability distribution over execution paths given the evidence. So PX|e(x) = P(x|e).

## Inference By Sampling

It would be tremendously useful if we could quickly sample from the posteriors PX|e . If we could do so, we could estimate E(h(x)|e) by averaging h(x) over many execution paths drawn from the posteriors.

## Exact Sampling By Rejection

We can sample slowly from the posteriors by rejection -
sampling from the priors PX by running the model program and discarding a sample x with probability (1-P(e|x)). This is in general too slow, since the expected number of tries to produce a sample goes up with the inverse likelihood of the evidence, and the evidence is likely to be highly improbable in most interesting problems. We will therefore concentrate on sampling approximately from the posteriors. 

## Single Point "Sampling" (Maximum Likelihood
