
## Search)

One way to sample approximately from the posteriors is to heuristically search for the most likely single execution path we can find given the evidence, and return it every time. Some advantages of this technique are:
1. It's simple 2. It can yield incremental results 3. The results are measurable.

4. It can be easily parallelized across computers and across search heuristics. 

5. The results can be good for probability distributions that are concentrated around a single execution path.

The downside of such a maximum likelihood search is that it performs poorly when the posterior distribution is spread out. For instance, in our example of the three dice which are observed to add to 7, there are many possible execution paths, all with identical posterior probabilities. 

This method would just pick one and be sure of it. 

Furthermore, this method discriminates against execution paths which cause more random numbers to be thrown, even if the results of those numbers are not used. 

## Guided Sampling (Variational Program Inference)

Our strategy for sampling will be to run the model program, but to bias the probability distribution on each one of its choices so that instead of drawing from the priors PX, the biased model program instead draws from a distribution which approximates the posteriors PX|e . 

We do this by means of a guide program G which runs alongside the model program and influences its random choices. Every time the main program calls the choose command with a prior probability distribution PC , the guide program computes and substitutes in its own distribution GC , and the choice c is chosen from GC
instead. Running the model program with the guide program alongside it samples from a guide-influenced distribution GX over execution paths. Our goal is to find a guide program G such that GX approximates PX|e .

For example, this is example 1 from above with a good guide program represented inline in angle brackets <>:

die1 := choose(uniform(1..6),  <guide: {1:1/3, 2:4/15, 3:1/5, 4:2/15, 5:1/15}>)  die2 := choose(uniform(1..6),  <guide: uniform(1..6-die1)>)  die3 := choose(uniform(1..6),  <guide: {7-(die1+die2):1.0}>)  *h* := (diel == 5)  evidence (diel + die2 + die3 == 7)
We say that the guide program runs alongside the model program, but in practice, it will be more convenient to have it consist of code segments which are attached inline to the model program. The one caveat is that the guide program may not affect the execution of the model program in any way except to provide alternate probability distributions for choose calls.

We will find a good guide program by heuristically searching over the space of all guide programs for one such that GX approximates PX|e . We will worry about search heuristics later, but the more pressing problem for now is how to tractably judge for a particular G how well GX approximates PX|e . 

## Evaluating A Guide Program By Free Energy

The measure of similarity we use is the Kulllbeck-Leibler divergence between GX and PX|e , which is defined as DKL(GX || PX|e) = Σx G(x) log(G(x) / P(x|e))
The KL divergence measures how quickly a wary observer can accrue evidence that you are sampling from GX instead of from PX|e. Smaller values of KL divergence indicate more similar distributions. 

By an amazing trick, the KL divergence becomes tractable to estimate if we will add the constant term -log(P(e)). Thus, we define the free energy of G as:
F(G, P, e) := DKL(GX || PX|e) -log(P(e)) = Σx G(x) log(G(x) / P(x|e)) - log(P(e)) = Σx G(x) log(G(x) / (P(x|e) * P(e)) ) = Σx G(x) log(G(x) / P(x,e)) = Σx G(x) log(G(x) / (P(x) * P(e|x)) ) = Σx G(x) ( log(G(x) / P(x)) - log(P(e|x) )
Lo and behold, we can estimate this last quantity by sampling from GX multiple times and computing the average value of log(G(x) / P(x)) - log(P(e|x)).

We call the quantity we are averaging the one-run free energy an execution path F(G, P, e, x) := log(G(x) / P(x)) - log(P(e|x))
This technique of searching for approximate posteriors which minimize the free energy is related to variational methods of probabilistic inference, where the guide program is the variational parameter. So we call the technique of searching for an optimal guide "Variational Program Inference". This can be read as either "Variational Program-Inference" or "Variational-Program Inference", 
since we are running inference over programs, and the variational parameter itself is a program.

Our technique differs from the typical use of variational probabilistic inference in that we estimate the free energy via sampling, while typically, the free energy is computed analytically. We assume that our problems will be too complex to allow for such an analytic computation.