makes explicit the type of relationship that exists between two web resources
[8, 7]. Furthermore, the Linked Data community has not only seen a need to link existing web resources in meaningful ways, but also a need to link the large amounts of non-typical web data (e.g. database information) [9].1 The standard for relating web resources on the Semantic Web is the Resource Description Framework (RDF) [8, 28]. RDF is a data model2that is used to create graphs of the form

$$R\subseteq\underbrace{(U\cup B)}_{\mathrm{subject}}\times\underbrace{U}_{\mathrm{\scriptsize~\ predicate}}\times\underbrace{(U\cup B\cup L)}_{\mathrm{\scriptsize~object}},$$
$$(1)$$

, (1)
where U is the infinite set of all URIs [42, 6], B is the infinite set of all blank nodes, and L is the infinite set of all literal values.3 An element in R is known as a statement, or triple, and it is composed of a set of three elements: a subject, a predicate, and an object. A statement in RDF asserts a fact about the world.

"The basic intuition of model-theoretic semantics is that asserting a sentence makes a claim about the world: it is another way of saying that the world is, in fact, so arranged as to be an interpretation which makes the sentence true. In other words, an assertion amounts to stating a constraint on the possible ways the world might be." [23]
An example RDF statement is (lanl:marko, foaf:knows, ucla:apepe).4 This statement makes a claim about the world: namely that "Marko knows Alberto". The foaf:knows predicate defines the meaning of the link that connects the subject lanl:marko to the object ucla:apepe. On the World Wide Web, the only way that such semantics could be derived in a computationally efficient manner would be to note that in Marko's webpage there exists an href link to Alberto's webpage. While this web link does not necessarily mean that "Marko knows Alberto", it is the simplest means, without text analysis techniques, to recognize that there exists a relationship between Marko and Alberto. Thus, for machines, the World Wide Web is a homogenous world of generic relationships. On the Semantic Web, the world is a rich, complicated network of meaningful relationships.

The evolution from the World Wide Web to the Semantic Web has brought greater meaning and expressiveness to our largest digital information reposi-1 The necessity to expose large amounts of data on the Semantic Web has driven the development of triple-store technology. Advanced triple-store technology parallels relational database technologies by providing an efficient medium for the storage and querying of semantic graphs [29, 26, 1].

2 RDF is a data model, not a serialization format. There exist various standard serialization formats such as RDF/XML, N3 [3], Turtle [2], Trix [13], etc.

3 Other formalisms exist for representing an RDF graph such as the directed labeled graph, bipartite graph [22], and directed hypergraph models [31].

4 All resources in this article have been prefixed in order to shorten their lengthy namespaces. For example, foaf:knows, in its extended form, is http://xmlns.com/foaf/0.1/knows.