answer the question: "What do you mean by 'Marko knows Alberto'?".

A notion from Ludwig Wittgenstein's theory of "language games" can be aptly borrowed: the meaning of a concept is not universal and set in stone, but shaped by "a complicated network of similarities, overlapping and crisscrossing" [46]. Following this line of thought, this article purposes a "dilated" model of an RDF triple. The dilated triple contextualizes the meaning and enhances the expressiveness of assertions on the Semantic Web.

## 2 The Dilated Triple Model

A single predicate URI does not provide the appropriate degrees of freedom required when modeling the nuances of an RDF relationship. The model proposed in this article enhances the expressiveness of a triple such that its meaning is considered within a larger context as defined by a graph structure.

It thereby provides a machine with the ability to discern the more fine-grained context in which a statement relates its subject and object.

In the proposed model, every triple in an RDF graph is supplemented with other triples from the same RDF graph. The triple and its supplements form what is called a *dilated triple*.

7 Definition 1 (A Dilated Triple). Given a set of triples R and a triple τ ∈ R, a dilation of τ is a set of triples Tτ ⊂ R such that τ ∈ Tτ .

The dilated form of τ ∈ R is Tτ . Informally, Tτ servers to elaborate the meaning of τ . Formally, Tτ is a graph that at minimum contains only τ and at maximum contains all triples in R. The set of all non-τ triples in Tτ (i.e. Tτ \τ )
are called *supplementary triples* as they serve to contextualize, or supplement, the meaning of τ . Finally, it is worth noting that every supplemental triple in Tτ has an associated dilated form, so that Tτ can be considered a set of nested sets.8 An instance of τ , its subject s, predicate p, object o, and its dilated form Tτ , are diagrammed in Figure 1.

![0_image_0.png](0_image_0.png)

