A dilated triple can be conveniently represented in RDF using a named graph [12]. Statements using the named graph construct are not triples, but instead, are quads with the fourth component being denoted by a URI or blank node. Formally, τ = (*s, p, o, g*) and g ∈ U ∪ B. The fourth component is considered the "graph" in which the triple is contained. Thus, multiple quads with the same fourth element are considered different triples in the same graph. Named graphs were developed as a more compact (in terms of space) way to reify a triple. The reification of a triple was originally presented in the specification of RDF with the rdf:Statement construct [28]. RDF
reification has historically been used to add specific metadata to a triple, such as provenance, pedigree, privacy, and copyright information. In this article, the purpose of reifying a triple is to supplement its meaning with those of additional triples. While it is possible to make additional statements about the dilated triple (i.e. the named graph component g), the motivation behind the dilated triple is to encapsulate many triples within a single graph, not to make statements about the graph *per se*.

The following sections will further explain the way in which a dilated triple contextualizes the meaning of a statement. §3 demonstrates, by means of an example, how supplementary triples augment the meaning of a relationship between two resources. §4 discusses how dilated triples can be compared and used by a machine to discern context.

## 3 Contextualizing A Relationship

The dilated form of x ∈ R, denoted Tx, provides a knowledge structure that is suited to contextualizing the meaning of an assertion made about the world.

For example, consider the asserted triple

## X = (Lanl:Marko, Foaf:Knows, Ucla:Apepe). (2)

What is the meaning of foaf:knows in this context? For the human, the meaning is made explicit in the specification document of the FOAF (Friend of a Friend) ontology (http://xmlns.com/foaf/spec/), which states:
"We take a broad view of 'knows', but do require some form of reciprocated interaction (i.e. stalkers need not apply). Since social attitudes and conventions on this topic vary greatly between communities, counties and cultures, it is not appropriate for FOAF to be overly-specific here."
Unfortunately, the supplementary information that defines the meaning of foaf:knows is not encoded with the URI itself (nor in the greater RDF
graph) and it is only through some external medium (the FOAF specification document) that the meaning of foaf:knows is made clear. Thus, such semantics are entirely informal [41]. However, even if the complexity of the meaning of foaf:knows could be conveyed by an RDF graph, the nuances of