Marko knows Alberto is much different than the context in which Marko knows Carole. The supplementary triples that compose Ty may be the RDF
expression of:
"Marko was born in Fairfield, California on November 30th, 1979. Carole is Marko's mother. Marko's family lived in Riverside (California), Peachtree City (Georgia),
Panama City (Panama), and Fairfax (Virginia). During his 10th grade high-school term, Marko moved with his family back to Fairfield, California."
It is obvious from these two examples that foaf:knows can not sufficiently express the subtleties that exist between two people. People know each other in many different ways. There are family relationships, business relationships, scholarly relationships, and so on. It is true that these subtleties can be exposed when performing a deeper analysis of the graph surrounding a foaf:knows relationship as other paths will emerge that exist between people
(e.g. vacation paths, transaction paths, coauthorship paths, etc.). The purpose of a dilated triple is to contain these corroborating statements within the relationship itself. The purpose of Tx is to identify those aspects of Marko and Alberto's "knowing" relationship that make it unique (that provide it the most meaning). Similarly, the purpose of Ty is to provide a finer representation of the context in which Marko knows his mother. The supplementary triples of Tx and Ty augment the meaning of foaf:knows and frame each respective triple x and y in a broader context.13

## 4 Comparing Contexts

The "Marko knows" examples from the previous section are reused in this section to explain how dilated triples can assist a machine in discerning and comparing the broader meaning of a statement. In order to present this example, the notion of a contextualized process is introduced. A contextualized process, as defined here, is a human or machine that maintains a perspective or expectation of how the world must be.

"Perspective in theory of cognition is the choice of a context or a reference (or the result of this choice) from which to sense, categorize, measure or codify experience, cohesively forming a coherent belief, typically for comparing with another."14 A perspective can be expressed in RDF by simply associating some process with a knowledge-base that defines what that process knows about the world.

This knowledge-base can be derived, for example, from the process' history and thus defined as a subgraph of the full RDF graph. With respect to a perspective based on history, it makes sense that a process does not "experience" 13 Examples of other predicates beyond foaf:knows also exist. For instance, suppose the predicates foaf:member and foaf:fundedBy. In what way is that individual a member of that group and how is that individual funded?

14 Wikipedia http://en.wikipedia.org/wiki/Perspective (cognitive).