# Mdps With Unawareness

Joseph Y. Halpern Nan Rong Ashutosh Saxena Computer Science Department Cornell University Ithaca, NY 14853
{halpern | rongnan | asaxena}@cs.cornell.edu

## Abstract

Markov decision processes (MDPs) are widely used for modeling decision-making problems in robotics, automated control, and economics. Traditional MDPs assume that the decision maker
(DM) knows all states and actions. However, this may not be true in many situations of interest. We define a new framework, MDPs with unawareness (MDPUs) to deal with the possibilities that a DM may not be aware of all possible actions. We provide a complete characterization of when a DM can learn to play near-optimally in an MDPU, and give an algorithm that learns to play near-optimally when it is possible to do so, as efficiently as possible. In particular, we characterize when a near-optimal solution can be found in polynomial time.

## 1 Introduction

Markov decision processes (MDPs) [2, 12, 16] have been used in a wide variety of settings to model decision making. The description of an MDP includes a set S of possible states and a set A of actions. Unfortunately, in many decision problems of interest, the decision maker (DM) does not know the state space, and is unaware of possible actions she can perform. For example, someone buying insurance may not be aware of all possible contingencies; someone playing a video game may not be aware of all the actions she is allowed to perform nor of all states in the game. The fact that the DM may not be aware of all states does not cause major problems. If an action leads to a new state and the set of possible actions is known, we can use standard techniques (discussed below) to decide what to do next. The more interesting issue comes in dealing with actions that the DM may not be aware of. If the DM is not aware of her lack of awareness then it is clear how to proceedwe can simply ignore these actions; they are not on the DM's radar screen. We are interested in a situation where the DM realizes that there are actions (and states) that she is not aware of, and thus will want to explore the MDP. We model this by using a special *explore* action. As a result of playing this action, the DM might become aware of more actions, whose effect she can then try to understand. We have been deliberately vague about what it means for a DM to be "unaware" on an action. We have in mind a setting where there is a (possibly large) space A∗ of *potential* actions. For example, in a video game, the space of potential actions may consist of all possible inputs from all input devices combined (e.g., all combinations of mouse movements, presses of keys on the keyboard, and eye movements in front of the webcam); if a DM is trying to prove a theorem, at least in principle, all possible proof techniques can be described in English, so the space of potential actions can be viewed as a subset of the set of English texts. The space A of *actual actions* is the (typically small) subset of A∗that are the "useful actions". For example, in a video game, these would be the combinations of arrow presses
(and perhaps head movements) that have an appreciable effect on the game. Of course, A∗ may not describe how the DM conceives of the potential acts. For example, a firsttime video-game player may consider the action space to include only presses of the arrow keys, and be completely unaware that eye movement is an action. Similarly, a mathematician trying to find a proof probably does not think of herself as searching in a space of English texts; she is more likely to be exploring the space of "proof techniques". A sophisticated mathematician or video game player will have a better understanding of the space that she views herself as exploring. Moreover, the space of potential actions may change over time, as the DM becomes more sophisticated. Thus, we do not explicitly describe A∗in our formal model, and abstract the process of exploration by just having an *explore* action. (It actually may make sense to have several different *explore* actions; we defer discussion of this point to Section 6.) This type of exploration occurs all the time. In video games, first-time players often try to learn the game by ex-