ploring the space of moves, without reading the instructions (and thus, without being aware of all the moves they can make). Indeed, in many games, there may not be instructions at all (even though players can often learn what moves are available by checking various sites on the web). Mathematicians trying to generate new approaches to proving a theorem can be viewed as exploring the space of proof techniques. More practically, in robotics, if we take an action to be a "useful" sequence of basic moves, the space of potential actions is often huge. For instance, most humanoid robots (such as Honda Asimo robot [18]) have more than 20 degrees of freedom; in such a large space, while robot designers can hand-program a few basic actions (e.g., as walking on a level surface), it is practically impossible to do so for other general scenarios (e.g., walking on uneven rocks). Conceptually, it is useful to think of the designer as not being aware of the actions that can be performed. Exploration is almost surely necessary to discover new actions necessary to enable the robot to perform the new tasks.

Given the prevalence of MPDUs—*MDPs with unawareness*, the problem of learning to play well in an MDPU
becomes of interest. There has already been a great deal of work on learning to play optimally in an MDP. Kearns and Singh [15] gave an algorithm called E3that converges to near-optimal play in polynomial time. Brafman and Tennenholtz [3] later gave an elegant algorithm they called RMAX that converges to near-optimal play in polynomial time not just in MDPs, but in a number of adversarial settings. Can we learn to play near-optimally in an MDPU?

(By "near-optimal play", we mean near-optimal play in the actual MDP.) In the earlier work, near-optimal play involved learning the effects of actions (that is, the transition probabilities induced by the action). In our setting, the DM still has to learn the transition probabilities, but also has to learn what actions are available. Perhaps not surprisingly, we show that how effectively the DM can learn optimal play in an MDPU depends on the probability of discovering new actions. For example, if it is too low, then we can never learn to play nearoptimally. If it is a little higher, then the DM can learn to play near-optimally, but it may take exponential time.

If it is sufficiently high, then the DM can learn to play near-optimally in polynomial time. We give an expression whose value, under minimal assumptions, completely characterizes when the DM can learn to play optimally, and how long it will take. Moreover, we show that a modification of the RMAX algorithm (that we call URMAX) can learn to play near-optimally if it is possible to do so. There is a subtlety here. Not only might the DM not be aware of what actions can be performed in a given state, she may be unaware of *how many* actions can be performed. Thus, for example, in a state where she has discovered five actions, she may not know whether she has discovered all the actions (in which case she should not explore further)
or there are more actions to be found (in which case she should). In cases where the DM knows that there is only one action to be discovered, and what its payoff is, it is still possible that the DM never learns to play optimally. Our impossibility results and lower bound hold even in this case. (For example, if the action to be discovered is a proof that P 6= NP, the DM may know that the action has a high payoff; she just does not know what that action is.) On the other hand, URMAX works even if the DM does not know how many actions there are to be discovered. There has been a great deal of recent work on awareness in the game theory literature (see, for example, [5, 6, 9, 11]). There has also been work on MDPs with a large action space (see, for example [4, 10]), and on finding new actions once exploration is initiated [1]. None of these papers, however, considers the problem of learning in the presence of lack of awareness; we believe that we are the first to do so.

The rest of the paper is organized as follows. In Section 2, we review the work on learning to play optimally in MDPs. In Section 3, we describe our model of MDPUs. We give our impossibility results and lower bounds in Section 4. In Section 5, we present a general learning algorithm (adapted from R-MAX) for MDPU problems, and give upper bounds. We conclude in Section 6. Missing proofs can be found in the full paper.

## 2 Preliminaries

In this section, we review the work on learning to play optimally in MDPs and, specifically, Brafman and Tennenholt's R-MAX algorithm [3].

MDPs: An MDP is a tuple M = (**S, A, P, R**), where S is a finite set of states; A is a finite set of actions; P : (S × S × A) → [0, 1] is the transition probability function, where P(s, s′, a) gives the transition probability from state s to state s
′ with action a; and R : (S ×
S × A) → IR+ is the reward function, where R(s, s′, a)
gives the reward for playing action a at state s and transiting to state s
′. Since P is a probability function, we have Ps
′∈S P(s, s′, a**) = 1** for all s ∈ S and a ∈ A.

A *policy* in an MDP (**S, A, P, R**) is a function from histories to actions in A. Given an MDP M = (**S, A, P, R**),
let UM(**s, π, T** ) denote the expected T -step undiscounted average reward of policy π started in state s—that is, the expected total reward of running π for T steps, divided by T . Let UM(s, π) = limT→∞ UM(**s, π, T** ), and let UM(π) = mins∈S UM (**s, π**).

The mixing time: For a policy π such that UM(π) = α, it may take a long time for π to get an expected payoff of α.

For example, if getting a high reward involves reaching a particular state s
∗, and the probability of reaching s
∗from