some state s is low, then the time to get the high reward will be high. To deal with this, Kearns and Singh [15] argue that the running time of a learning algorithm should be compared to the time that an algorithm with full information takes to get a comparable reward. Define the ǫ-return mixing time of policy π to be the smallest value of T such that π guarantees an expected payoff of at least U(π) − ǫ; that is, it is the least T such that U(**s, π, t**) ≥ U(π) − ǫ for all states s and times t ≥ T . Let Π(**ǫ, T** ) consist of all policies whose ǫ-mixing time is at most T . Let Opt(M, ǫ, T ) = maxπ∈Π(ǫ,T) UM (π).

RMAX: RMAX [3] is a model-based near-optimal polynomial-time reinforcement learning algorithm for zero-sum stochastic games (SG), which also directly applies to standard MDPs. RMAX assumes that the DM
knows all the actions that can be played in the game, but needs to learn the transition probabilities and reward function associated with each action. It does not assume that the DM knows all states; new states might be discovered when playing actions at known states. RMAX follows an implicit
"explore or exploit" mechanism that is biased towards exploration. Here is the RMAX algorithm:

## Rmax(|S|, |A|, Rmax**, T, Ǫ, Δ, S**0):

Set K1(T **) := max((**⌈
4|S| T Rmax ǫ⌉)
3, ⌈−**6 ln**3(δ 6|S| |A| 2 )⌉**) + 1**
Set M′:= M0(the initial approximation described below)
Compute an optimal policy π
′for M′
Repeat until all action/state pairs (**s, a**) are *known* Play π
′starting in state s0 for T steps or until some new state-action pair (**s, a**) is known if (**s, a**) has just become *known* **then** update M′so that the transition probabilities for (**s, a**) are the observed frequencies and the rewards for playing (**s, a**) are those that have been observed.

Compute the optimal policy π
′for M′
Return π
′.
Here Rmax is the maximum possible reward; ǫ > 0; 0 **< δ <** 1; T is the ǫ-return mixing time; K1(T ) represents the number of visits required to approximate a transition function; a state-action pair (**s, a**) is said to be *known* only if it has been played K1(T ) times. RMAX proceeds in iterations, and M′is the current "approximation" to the true MDP. M′consists state set S and a dummy state sd.

The transition and reward functions in M′ may be different from those of the actual MDP. In the initial approximation M0, the transition and reward functions are trivial: when an action a is taken in any state s (including the dummy state sd), with probability 1 there is a transition to sd, with reward Rmax.

Brafman and Tennenholtz [3] show that RMAX(|S|, |A|, Rmax**, T, ǫ, δ, s**0) learns a policy with expected payoff within ǫ of Opt(**M, ǫ, T** ) with probability greater than 1 − δ, no matter what state s0 it starts in, in time polynomial in |S|, |A|, T , 1/δ, and 1/ǫ. What makes RMAX work is that in each iteration, it either achieves a near-optimal reward with respect to the real model or learns an unknown transition with high probability. Since there are only polynomially-many (**s, a**) pairs (in the number of states and actions) to learn, and each transition entry requires K1(T ) samples, where K1(T ) is polynomial in the number of states and actions, 1/ǫ, 1/δ, and the ǫ-return mixing time T , RMAX clearly runs in time polynomial in these parameters. In the case that the ǫ-return mixing time T is not known, RMAX starts with T = 1, then considers T = 2, T = 3, and so on. We expand on this point further in Section 5, for in an MDPU we need to deal with the fact that the number of states and actions is unknown.

## 3 Mdps With Unawareness

Intuitively, an MDPU is like a standard MDP except that the player is initially aware of only a subset of the complete set of states and actions. To reflect the fact that new states and actions may be learned during the game, the model provides a special *explore* action. By playing this action, the DM may become aware of actions that she was previously unaware of. The model includes a discovery probability function characterizing the likelihood that a new action will be discovered. At any moment in game, the DM can perform only actions that she is currently aware of.

Definition 3.1 : An MDPU is a tuple M =
(S, A, S0, a0, gA, g0, P, D, R, R+, R−), where

- S, the set of states in the underlying MDP;
- A, the set of actions in the underlying MDP;
- S0 ⊆ S is the set of states that the DM is initially aware of;
- a0 ∈/ A is the *explore* action;
- gA : S → 2 A, where gA(s) is the set of actions that can be performed at s other than a0 (we assume that a0 can be performed in every state);
- g0 : S0 → 2 A, where g0(s) ⊆ gA(s) is the set of actions that the DM is aware of at state s (we assume that the DM is always aware of a0);
- P : ∪s∈S({s} × S × gA(s) → [0, 1] is the transition probability function (as usual, we require that Ps
′∈S P(s, s′, a**) = 1** if a ∈ gA(s));
- D : IN × IN × S → [0, 1] is the discovery probability function. D(**j, t, s**) gives the probability of discovering a new action in state s ∈ S given that there are j actions to be discovered and a0 has already been played t − 1 times in s without a new action being discovered (see below for further discussion);