the DM knows only S0, g0, D, R+, and R− (we assume that the DM always knows at least this), then every MDP
(S
′, A′, g′, P′, R′) where S0 ⊆ S
′and g0(s) ⊆ A′(s)
is compatible with the DM's knowledge. If the DM also knows |S|, then we must have |S
′| = |S|; if the DM
knows that S = S0, then we must have S
′ = S0. We use Rmax to denote the maximum possible reward. Thus, if the DM knows Rmax, then in a compatible MDP, we have R(s, s′, a′) ≤ Rmax, with equality holding for some transition. (The DM may just know a bound on Rmax, or not know Rmax at all.) If the DM knows Rmax, we assume that R+(s) < Rmax for all s ∈ S (for otherwise, the optimal policy for the MDPU becomes trivial: the DM should just get to state s and keep exploring). Brafman and Tennenholtz essentially assume that the DM knows |A|, |S|, and Rmax. They say that they believe that the assumption that the DM knows Rmax can be removed. It follows from our results that, in fact, the DM does not need to know any of |A|, |S|, or Rmax.

Our theorems talk about whether there is an algorithm for a DM to learn to play near-optimally given some knowledge. We define "near-optimal play" by extending the definitions of Brafman and Tennenholtz [3] and Kearns and Singh [15] to deal with unawareness. In an MDPU, a policy is again a function from histories to actions, but now the action must be one that the DM is aware of at the last state in the history. The DM *can learn to play near-optimally given a state* space S0 *and some other knowledge* if, for all ǫ > 0, δ > 0, T , and s ∈ S0, the DM can learn a policy π**ǫ,δ,T,s** such that, for all MDPs M compatible with the DM's knowledge, there exists a time t**M,ǫ,δ,T** such that, with probability at least 1 − δ, UM(s, πǫ,δ,T,s, t) ≥ Opt(**M, ǫ, T** ) − ǫ for all t ≥ t**M,ǫ,δ,T** .

3 The DM *can learn to play nearoptimally given some knowledge in polynomial (resp., exponential) time* if, there exists a polynomial (resp., exponential) function f of five arguments such that we can take tM,ǫ,δ,T = f(T, |S|, |A|, 1/ǫ, 1/δ).

## 4 Impossibility Results And Lower Bounds

The ability to estimate in which cases the DM can learn to play optimally is crucial in many situations. For example, in robotics, if the probability of discovering new actions is so low that it would would require an exponential time to learn to play near-optimally, then the designer of the robot must have human engineers design the actions and not rely on automatic discovery. We begin by trying to understand when it is feasible to learn to play optimally, and then consider how to do so.

We first show that, for some problems, there are no algorithms that can guarantee near-optimal play; in other cases, there are algorithms that will learn to play near-optimally, but will require at least exponential time to do so. These results hold even for problems where the DM knows that there are two actions, already knows one of them, and knows the reward of the other.

In the following examples and theorem, we use Et,s to denote the event of playing a0 t times at state s without discovering a new action, conditional on there being at least one undiscovered action.

Example 4.1: Suppose that the DM knows that S = S0 = {s1}, g0(s1) = {a1}, |A| = 2, P(s1, s1, a**) = 1** for all action a ∈ A, R(s1, s1, a1) = r1, R+(s1) = R−(s1**) = 0**,
D(j, t) = 1
(t+1)2 , and the reward for the optimal policy in the true MDP is r2, where r2 > r1. Since the DM knows that there is only one state and two actions, the DM knows that in the true MDP, there is an action a2 that she is not aware of such that R(s1, s1, a2) = r2. That is, she knows everything about the true MDP but the action a2. We now show that, given this knowledge, the DM cannot learn to play optimally. Clearly in the true MDP the optimal policy is to always play a2. However, to play a2, the DM must learn about a2. As we now show, no algorithm can learn about a2 with probability greater than 1/2, and thus no algorithm can attain an expected return ≥ (r1 + r2)/2 = r2 − (r2 − r1)/2.

Since there is exactly one unknown action, and the DM
knows this, we have

$$\begin{array}{r c l}{{P r(E_{t,s_{1}})}}&{{=}}&{{\prod_{t^{\prime}=1}^{t}(1-D(1,t^{\prime}))}}\\ {{}}&{{=}}&{{\prod_{t^{\prime}=1}^{t}\left(1-\frac{1}{(t^{\prime}+1)^{2}}\right)}}\\ {{}}&{{=}}&{{\frac{t+2}{2(t+1)}}}\\ {{}}&{{>}}&{{\frac{1}{2}.}}\end{array}$$

For the third equality, note that 1 −1
(t
′+1)2 **= (1** −1 t
′+1 ) ×
(1 + 1 t
′+1 ); it follows that

$$\prod_{t^{\prime}=1}^{t}\left(1-\frac{1}{(t^{\prime}+1)^{2}}\right)=\left(\frac{1}{2}\times\frac{3}{2}\right)\times\left(\frac{2}{3}\times\frac{4}{3}\right)\times\cdots$$  $$\times\left(\frac{t}{t+1}\times\frac{t+2}{t+1}\right).$$

All terms but the first and last cancel out. Thus, the product is t+2 2(t+1) , as desired. The inequality above shows that P r(Et, s1) is always strictly greater than 1/2, independent of t. In other words, the DM cannot discover the better action a2 with probability greater than 1/2 no matter how many times a0 is played. It easily follows that the expected reward of any policy is at most (r1 + r2)/2. Thus, there is no algorithm that learns to play near-optimally.