
## The Parameters That K1(T ) Depends On.

We now describe the URMAX algorithm under the assumption that the DM knows N, an upper bound on the state space S, k, an upper bound on the size of the action space A, Rmax, an upper bound on the true maximum reward, and T , an upper bound on the ǫ-return mixing time. To emphasize the dependence on these parameters, we denote the algorithm URMAX(S0, g0, D, N, k, Rmax**, T, ǫ, δ, s**0).

(The DM may also know R+ and R−, but the algorithm does not need these inputs.) We later show how to define URMAX(S0, g0**, D, ǫ, δ, s**0), dropping the assumption that the DM knows N, k, T and Rmax.

Define

$$\bullet\ K_{1}(T)=\operatorname*{max}((\lceil{\frac{4N T R_{\mathrm{max}}}{\epsilon}}\rceil)^{3},\lceil8\ln^{3}({\frac{8N k}{\delta}})\rceil)+1;$$

$K_{0}=\min_{M}\{M:\sum_{t=1}^{M}D(1,t)\geq\ln(4N/\delta)\}$. (Such a $K_{0}$ always exists if $\sum_{t=1}^{M}D(1,t)=\infty$.)
Just as with RMAX, K1(T ) is a bound on how long the DM
needs to get a good estimate of the transition probabilities at each state s. Our definition of K1(T ) differs slightly from that of Brafman and Tennenholtz (we have a coefficient 8 rather than 6; the difference turn out to be needed to allow for the fact that we do not know all the actions).

As we show below (Lemma 5.1), K0 is a good estimate on how often the *explore* action needs to be played in order to ensure that, with high probability (greater than 1 − δ/4N),
at least one new action is discovered at a state, if there is a new action to be discovered. Just as with RMAX, we take a pair (**s, a**) for a 6= a0 to be *known* if it is played K1 times; we take a pair (**s, a**0) to be *known* if it is played K0 times.

URMAX(S0, g0, D, N, k, Rmax**, T, ǫ, δ, s**0) proceeds just like RMAX(N, k, Rmax**, T, ǫ, δ, s**0), except for the following modifications:

- The algorithm terminates if it discovers a reward greater than Rmax, more than k actions, or more than N states (N, k, and Rmax can be viewed as the current guesses for these values; if the guess is discovered to be incorrect, the algorithm is restarted with better guesses.)
- if (**s, a**0) has just become known, then we set the reward for playing a0 in state s to be −∞ (this ensures that a0 is not played any more in state s).
For future reference, we say that *an inconsistency is discovered* if the algorithm terminates because it discovers a reward greater than Rmax, more than k actions, or more than N states.

The next lemma shows that K0 has the required property.

Lemma 5.1: Let K0 *be defined as above. If the DM plays* a0 K0 times at state s*, then with probability* ≥ 1 − δ/4N
a new action will be discovered if there is at least one new action at state s *to be discovered.* Proof: Suppose that s is a state where the DM is unaware of j ≥ 1 actions. Then

$$\begin{array}{r c l}{{P r(E_{K_{0},s})}}&{{=}}&{{\prod_{t^{\prime}=1}^{K_{0}}(1-D(j_{s},t^{\prime}))}}\\ {{}}&{{}}&{{\leq}}&{{\prod_{t^{\prime}=1}^{K_{0}}(1-D(1,t^{\prime})).}}\end{array}$$
We show below that $1-D(1,t^{\prime})\leq e^{-D(1,t^{\prime})}$. Thus,
$$\begin{array}{r c l}{{\mathrm{Pr}(E_{K_{0},s})}}&{{\leq}}&{{\prod_{t^{\prime}=1}^{K_{0}}e^{-D(1,t^{\prime})}}}\\ {{}}&{{}}&{{\leq}}&{{e^{-\sum_{t^{\prime}=1}^{K_{0}}D(1,t^{\prime})}.}}\end{array}$$

The choice of K0 guarantees that PK0
t=1 D(1, t) ≥
ln(4N/δ). Thus,
$$\begin{array}{r c l}{{\mathrm{Pr}(E_{K_{0},s})}}&{{\leq}}&{{e^{-\ln(4N/\delta)}=\frac{\delta}{4N}.}}\end{array}$$
It remains to show that 1 − D(1, t′) ≤ e
−D(1,t′). Since D(1, t′) ≥ 0, it suffices to show that 1−x ≤ e
−xfor x ≥ 0.

Let g(x**) = 1** − x − e
−x. We want to show that g(x) ≤ 0 for x ≥ 0. An easy substitution shows that g**(0) = 0**. Differentiating g, we get that g
′(x) = −1 + e
−x ≤ 0 when x ≥ 0. Since g**(0) = 0** and g is nonincreasing when x ≥ 0, we must have g(x) ≤ 0 for x ≥ 0, as desired.

We first show that URMAX(S0, g0, D, N, k, Rmax**, T, ǫ, δ, s**0)
is correct provided that the parameters are correct.

Theorem 5.2: *For all MDPs* M = (**S, g, A, P, R**) *compatible with* S0, g0, N, k, Rmax*, and T (i.e.,* S ⊇ S0, g(s) ⊇
g0(s) *for all* s ∈ S0, |S| ≤ N, |A| ≤ k, R(s, s′, a) ≤ Rmax *for all* **s, s**′ ∈ S and a ∈ A, and the ǫ-return mixing time of M is ≤ T ), and all states s0 ∈ S0*, with probability* at least 1 − δ, URMAX(S0, g0, D, N, k, Rmax**, T, ǫ, δ, s**0)
running on M *returns a policy whose expected return is* at least Opt(**M, ǫ, T** ) − 2ǫ. Moreover, it does so in time polynomial in N, k, T ,
1 ǫ
,
1 δ
, Rmax*, and* K0.

Proof: The basic structure of the proof follows lines similar to the correctness proof of RMAX [3]. (Related results are proved in [1, 13, 14, 15].) We sketch the details here.

The running time is clear from the description of the algorithm. Let Mr = (Sr, Ar, gr, Pr, Rr) be the MDP that is finally computed by URMAX in execution r of the policy.

Thus, Sr is the set of states discovered in execution r, Ar is the set of actions discovered, and so on. Although Mr may not be identical to M, we will show that the set of executions r where Opt(Mr, ǫ, T ) ≥ Opt(**M, ǫ, T** ) − 2ǫ has probability at least 1 − δ, where the probability of an execution is determined by the transition probabilities P of the actual MDP M. The key points of the argument are the following.