Algorithm 2: Iterative algorithm for solving (BP–m)

1 (x0, w0) ← random ;
2 (y0, z0) ← arg miny,z f(w0, x0*, y, z*) ;
3 i ← 1 ;
4 while yi−1 6= yi or xi−1 6= xi do 5 (yi, zi) ← arg min{y,z A2y+B2z=b2 y,z≥0} f(wi−1, xi−1*, y, z*) ; 6 (xi, wi) ← arg min{x,w A1x+B1w=b1 x,w≥0} f(w, x, yi, zi) ;
7 i ← i + 1 8 return f(wi, xi, yi, zi)
programs which can be easily solved. Interestingly, as we will show in Section 7, algorithm 2 applied to ABP generalizes a version of API.

While algorithm 2 is not guaranteed to find an optimal solution, its empirical performance is often remarkably good (Mangasarian, 1995). Its basic properties are summarized by the following proposition.

Proposition 23 (e.g. (Bennett and Mangasarian, 1992)). algorithm 2 *is guaranteed to* converge, assuming that the linear program solutions are in a vertex of the optimality simplex. In addition, the global optimum is a fixed point of the algorithm, and the objective value monotonically improves during execution.

The proof is based on the finite count of the basic feasible solutions of the individual linear programs. Because the objective function does not increase in any iteration, the algorithm will eventually converge.

algorithm 2 can be further refined in case of approximate bilinear programs. For example, the constraint v ∈ M in the bilinear programs serves just to simplify the bilinear program and a value function that violates it may still be acceptable. The following proposition motivates the construction of a new value function from two transitive-feasible value functions.

Proposition 24. Let v˜1 and v˜2 *be feasible value functions in* (ABP–L∞)*. Then the value* function v˜(s) = min{v˜1(s), v˜2(s)}
is also feasible in bilinear program (ABP–L∞)*. Therefore* v˜ ≥ v
∗ and

$$|v^{*}-{\tilde{v}}||_{\infty}\leq1$$

kv
∗ − v˜k∞ ≤ min {kv
∗ − v˜1k∞, kv
∗ − v˜2k∞} .

The proof of the proposition is based on Jensen's inequality and is provided in the appendix. Note that ˜v may have a greater Bellman residual than either ˜v1 or ˜v2.

Proposition 24 can be used to extend algorithm 2 when solving ABPs. One option is to take the state-wise minimum of values from multiple random executions of algorithm 2, which preserves the transitive feasibility of the value function. However, the increasing number of value functions used to obtain ˜v also increases the potential sampling error.