
## 6. Sampling Guarantees

In most practical problems, the number of states is too large to be explicitly enumerated.

Even though the value function is restricted to be representable, the problem cannot be solved. The usual approach is to sample a limited number of states, actions, and their transitions to approximately calculate the value function. This section shows basic properties of the samples that can provide guarantees of the solution quality with incomplete samples.

First, we show a formal definition of the samples and then show how to use them. The simplest samples are defined as follows.

Definition 25. *One-step simple samples* are defined as:

$$\tilde{\Sigma}\subseteq\{(s,a,(s_{1}\ldots s_{n}),r(s,a))\,\big|\,s,s^{\prime}\in{\mathcal{S}},\;a\in{\mathcal{A}}\},$$
where $s_{1}\ldots s_{n}$ are selected i.i.d. from the distribution $P(s,a)$.  
More informative samples include the full distribution instead of samples from the distribution. While these samples are often unavailable in practice, they are useful in the theoretical analysis of sampling issues.

Definition 26. *One-step samples with expectation* are defined as follows:

$$\bar{\Sigma}\subseteq\{(s,a,P(s,a),r(s,a))\,|\,s\in{\mathcal{S}},\,a\in{\mathcal{A}}\}.$$

Membership a state in the samples is denoted simply as s ∈ Σ or (*s, a*) ∈ Σ with the remaining variables, such as r(*s, a*) considered to be available implicitly.

The sampling models may vary significantly in different domains. The focus of this work is on problems with either a fixed set of available samples or a domain model. Therefore, we do not analyze methods for gathering samples. We also do not assume that the samples come from previous executions, but rather from a deliberate sample-gathering process.

The samples are used to approximate the Bellman operator and the set of transitivefeasible value functions.

Definition 27. The *sampled Bellman operator* and the corresponding set of sampled transitive-feasible functions are defined as:

$$\begin{array}{c c c}{{(\bar{L}(v))(\bar{s})=}}&{{\operatorname*{max}_{\{a\,|\,(\bar{s},a)\in\Sigma\}}r(\bar{s},a)+\gamma\sum_{s^{\prime}\in\Sigma}P(\bar{s},a,s^{\prime})v(s^{\prime})}}&{{\quad\forall\bar{s}\in\Sigma}}\\ {{}}&{{}}&{{}}\\ {{\bar{\cal K}=\left\{v\,|\,(\bar{s},a,P(\bar{s},a),r(\bar{s},a))\in\bar{\Sigma},\;v(\bar{s})\geq(\bar{L}v)(\bar{s})\right\}}}\end{array}$$

The less-informative set of samples Σ can be used as follows. ˜
Definition 28. The *estimated Bellman operator* and the corresponding set of estimated transitive-feasible functions are defined as:

$$(\tilde{L}(v))(\bar{s})=\operatorname*{max}_{\{a\,|\,(\bar{s},a)\in\tilde{\Sigma}\}}r(\bar{s},a)+\gamma\frac{1}{n}\sum_{i=1}^{n}v(s_{i})\qquad\forall\bar{s}\in\tilde{\Sigma}$$ $$\tilde{K}=\left\{v\,\Big{|}\,(\bar{s},a,(s_{1}\ldots s_{n}),r(\bar{s},a))\in\tilde{\Sigma},\;v(\bar{s})\geq(\tilde{L}v)(\bar{s})\right\}$$
$$\quad(16)$$  $$\quad(17)$$
$$\left(18\right)$$ $$\left(19\right)$$
o(19)