Corollary 33. Optimistic approximate policy iteration converges in finite time. In addition, the Bellman residual of the generated value functions monotonically decreases.

OAPI differs from L∞-API in two ways: 1) OAPI constrains the Bellman residuals by 0 from below and by φ from above, and then it minimizes φ. L∞-API constrains the Bellman residuals by φ from both above and below. 2) OAPI, like API, uses only the current policy for the upper bound on the Bellman residual, but uses all the policies for the lower bound on the Bellman residual.

L∞-API cannot return an approximate value function that has a lower Bellman residual than ABP, given the optimality of ABP described in Theorem 13. However, even OAPI, an approximate ABP algorithm, performs comparably to L∞-API, as the following theorem states.

Theorem 34. Assume that L∞-API converges to a policy π and a value function v that both satisfy: φ = kv − Lπvk∞ = kv − Lvk∞*. Then*

$$\tilde{v}=v+\frac{\phi}{1-\gamma}{\bf1}$$

is feasible in the bilinear program (ABP–L∞), and it is a fixed point of OAPI. In addition, the greedy policies with respect to v˜ and v *are identical.*
Notice that while the optimistic and standard policy iterations can converge to the same solutions, the steps in their computation may not be identical. The actual results will depend on the initialization.

To prove the theorem, we first consider L∞-API2 as a modification of L∞-API. L∞-
API2 is shown in algorithm 1, where Z(π) is calculated using the following program:

$$\begin{array}{ll}\min&\phi\\ \mbox{s.t.}&({\bf I}-\gamma P_{a})v+{\bf1}\phi\geq r_{a}\quad\forall a\in{\cal A}\\ &-({\bf I}-\gamma P_{\pi})v+{\bf1}\phi\geq-r_{\pi}\\ &v\in{\cal M}\end{array}\tag{21}$$

The difference between linear programs (4) and (27) is that (4) involves only the current policy, while (27) bounds (I − γPa)v + 1φ ≥ ra from below for all policies. Linear program
(27) differs from linear program (20) by not bounding the Bellman residual from below by 0.

Proposition 35. L∞-API and L∞-API2 *generate the same sequence of policies if the initial* policies and tie-breaking is the same.

Proof. The proposition follows simply by induction from Lemma 39. The basic step follows directly from the assumption. For the inductive step, let π 1 i = π 2 i
, where π 1 and π 2 are the policies with (4) and (27). Then from Lemma 39, we have that the corresponding value functions v 1 i = v 2 i + c1. Because π 1 i+1 and π 2 i+1 are chosen greedily, we have that π 1 i+1 = π 2 i+1.

The proof of Theorem 34 follows.