

![0_image_0.png](0_image_0.png)

Consider a SAT problem with clauses Ci:

$$\bigwedge_{i=1,\ldots,n}C_{i}=\bigwedge_{i=1,\ldots,n}(l_{i1}\lor l_{i2}\lor l_{i3})\,,$$

where lij are literals. A literal is a variable or a negation of a variable. The variables in the SAT are x1 *. . . x*m. The corresponding MDP is constructed as follows. It has one state s(lij ) for every literal lij , one state s(Ci) for each clause Ci and an additional state ¯s. That is:
S = {s(Ci) i = 1, . . . , n*} ∪ {*s(lij ) i = 1*, . . . , n, j* = 1, . . . , 3*} ∪ {*s¯}.

There are 3 actions available for each state s(Ci), which determine the true literal of the clause. There is only a single action available in states s(lij ) and ¯s. All transitions in the MDP are deterministic. The transition t(*s, a*) = (s 0, r) is from the state s to s 0, when action a is taken, and the reward received is r. The transitions are the following:

$$t(s(C_{i}),a_{j})=(s(l_{ij}),1-\gamma)\tag{24}$$ $$t(s(l_{ij}),a)=(s(l_{ij}),-(1-\gamma))$$ (25) $$t(\bar{s},a)=(\bar{s},2-\gamma)\tag{26}$$

Notice that the rewards depend on the discount factor γ, for notational convenience.

There is one approximation feature for every variable xk such that:

$$\phi_{k}(s(C_{i}))=0$$
$$\phi_{k}({\bar{s}})=0$$

$$\phi_{k}(s(l_{i j}))=\begin{cases}1&\text{if}l_{i j}=x_{k}\\ -1&\text{if}l_{i j}=\neg x_{k}\end{cases}$$

An additional feature in the problem φ¯ is defined as:

$$\begin{array}{c}{{\bar{\phi}(s(C_{i}))=1}}\\ {{\bar{\phi}(s(l_{i j}))=0}}\\ {{\bar{\phi}(\bar{s})=1.}}\end{array}$$
