
## 5.1 Uniform Equivalence Under Herbrand Interpretations

The results in the previous section generalize the notion of uniform equivalence to programs under generalized open answer-set semantics and provide alternative characterizations for other notions of equivalence. They apply to programs under open answer-set semantics and ordinary answer-set semantics, when QHT-interpretations are restricted to extended Herbrand interpretations and Herbrand interpretations, respectively. In order to capture strong and uniform equivalence under ordinary answer-set semantics correctly, interpretations under the Standard Name Assumption (SNA) have to be considered, accounting for the potential extensions. For programs Π1 and Π2 and e ∈ {**c, a, s, u**}, we use Π1 ≡E
e Π2 and Π1 ≡H
e Π2 to denote (classical, answer-set, strong, or uniform) equivalence under open answer-set semantics and ordinary answer-set semantics, respectively. Corollary 7 Given two programs Π1 and Π2, it holds that
- Π1 ≡E
e Π2, C
E

e
(Π1) = C
E

e
(Π2), and EE
e
(Π1) = EE
e
(Π2) are equivalent; and
- Π1 ≡H
e Π2, C
H

e(Π1) = C
H

e(Π2), and EH
e(Π1) = EH
e(Π2) are equivalent; where e ∈ {**c, a, s, u**}, superscript E denotes the restriction to extended Herbrand interpretations, and superscript H denotes the restriction to Herbrand interpretations for e ∈ {**c, a**},
respectively to SNA interpretations for e ∈ {**s, u**}.

For safe programs open answer sets and ordinary answer sets coincide (de Bruijn et al. 2007).

Note that a fact is safe if it is ground. We obtain that uniform equivalence coincides under the two semantics even for programs that are not safe. Intuitively, the potential addition of arbitrary facts accounts for the difference in the semantics since it requires to consider larger domains than the Herbrand universe.5 Theorem 9 Let Π1, Π2 be programs over L. Then, Π1 ≡Eu Π2 iff Π1 ≡H
u Π2.

Proof The only-if direction is trivial. For the if direction, towards a contradiction assume that Π1 ≡H
u Π2 and Π1 6≡Eu Π2. Let Π be a factual program such that M = hid**, K, K**i is an extended Herbrand QHT-interpretation over L
′ ⊇ L on U
′
, such that M is in EE
a
(Π1 ∪Π),
but M 6∈ EE
a
(Π2 ∪ Π). Consider the signature LU′ = hU′,L
′

P ∪ {d}i, where L
′

P are the predicate symbols of L
′
, and d **6∈ L**′P is a fresh unary predicate symbol. Clearly, LU′ ⊃ L′.

Furthermore let Π′1 = Π1 ∪ Π ∪ {d(X)}, Π′2 = Π2 ∪ Π ∪ {d(X)}, and K′ = K ∪ {d(c) | c ∈ U′}. We show that M′ = hid, K′, K′i is in EH
a
(Π′1
), but M′ 6∈ EH
a
(Π′2
). Since M |= Π1 ∪ Π and no sentence in Π1 ∪ Π involves d, we conclude M′|= Π1 ∪ Π. By construction, M′is also a QHT-model of d(X), hence M′|= Π′1
. Moreover, hid, J, K**i 6|**=
Π1 ∪Π, for every J ⊂ K. Therefore, for every J
′ = J ∪ {d(c) | c ∈ U′} such that J ⊂ K,
hid, J′, K′**i 6|**= Π′1
. So let us consider proper subsets J
′ of K′such that K ⊆ J, i.e.,
J
′ ⊂ {d(c) | c ∈ U′}. In this case hid, J′, K′**i 6|**= d(X), and again hid, J′, K′**i 6|**= Π′1
. This proves that M′is in EH
a(Π′1). On the other hand, if M 6|= Π2∪Π, then M 6|= Π2, and since