# An Efficient Technique For Similarity Identification Between Ontologies

## Amjad Farooq, Syed Ahsan And Abad Shah

Abstract -Ontologies usually suffer from the semantic heterogeneity when simultaneously used in information sharing, merging, integrating and querying processes. Therefore, the similarity identification between ontologies being used becomes a mandatory task for all these processes to handle the problem of semantic heterogeneity. In this paper, we propose an efficient technique for similarity measurement between two ontologies. The proposed technique identifies all candidate pairs of similar concepts without omitting any similar pair. The proposed technique can be used in different types of operations on ontologies such as merging, mapping and aligning. By analyzing its results a reasonable improvement in terms of completeness, correctness and overall quality of the results has been found. 

Index Terms - Ontology Alignment, Semantic Web, Ontology Heterogeneity 
——————————  —————————— 

## 1. Introduction

It is quite difficult to retrieve relevant information from current web due to semantic heterogeneity problem in addition to other problems. Semantic web suggested solution of retrieval of specific information through ontologies, but ontologies may themselves suffer the heterogeneity problem when they are integrated, merged, shared, etc [1]. Same concept may be given different names or may be defined in different ways in two ontologies, although both ontologies belong to the same domain and may overlap. In order to use them together for different purposes such as merging, integrating, querying or even in creating a new ontology, those need to be aligned [2]. There are several techniques for aligning ontologies. They are mainly grouped into two classes: schema-based techniques and instance-based techniques. In schemabased techniques, the similarity among concepts of both ontologies is measured at structure-level while ignoring their actual data, whereas in instance-level techniques the similarity decision is made by taking actual data into consideration [3]. Ontology alignment at schema-level has different classifications such as structural, semantic, terminological and extensional [4]. Techniques for structural alignment are further divided into two classes: External structural alignment techniques and internal structural alignment techniques. External structure of a concept consists of the following elements [2], [5], [6]: super concepts; sub-concepts, sibling concepts and its nontaxonomic relations with the concepts. Therefore, when a concept Ci of ontology A is aligned with a concept Cj of ontology B, then all these elements i.e. super, sub and siblings are taken into consideration in the externalstructure level alignment of a concept. Structure-level similarities between concepts of ontologies are computed using different criteria [7],[8], [9], [10] such as their direct super-entities (or all of their super-entities) are already similar; their sibling-entities (or all of their siblingentities) are already similar; their direct sub-entities (or all of their sub-entities) are already similar; all (or most) of their descendant-entities (entities in the sub-tree rooted at the entity in question) are already similar; all (or most) of their leaf-entities (entities, which have no sub-entity, in the sub-tree rooted at the entity in question) are already similar and all (or most) of entities in the paths from the root to the entities in question are already similar. While aligning different ontologies using criteria as mentioned above, we observe that certain pairs of similar concepts remain unaligned because those concepts don't satisfy these criteria .e. their respective surrounding concepts are not similar. Secondly, the matching process should be made at domain vocabulary declaration level, to make it more generic, simple and efficient. Since domain vocabulary is the foundation of ontology, therefore it is easy and efficient to make an alignment between domain vocabularies of two ontologies. In the alignment process, first domain vocabularies of both ontologies are enriched by equipping each domain concept with its possible synonyms and then the similarities between concepts of both vocabularies are determined and formalized. Finally, both ontologies may be adapted accordingly. 