OWL Lite is the simplest version of OWL and provides classification hierarchy and simple constraints, being designed for easy implementation. In this sublanguage there is some restriction of OWL DL to a subset of language constructors, with some limitations such as an absence of explicit negation or union; restricted expressiveness is the disadvantage of this sublanguage. 

OWL DL (short for: Description Logic) the name of this sublanguage shows that it has more Description Logic to represent the relation between objects and their properties. Indeed, it provides maximum expressiveness while preserving the completeness of computational properties. OWL Lite is a sublanguage of OWL 
DL. 

The sublanguage OWL Full provides maximum expressiveness. OWL Lite and OWL DL are sublanguages of OWL Full. 

## Table (1)

COMPARISON BETWEEN ONTOLOGY LANGUAGES

| The expression                                             | RDF/RDFS   | DAML+OIL   | OWL       |    |
|------------------------------------------------------------|------------|------------|-----------|----|
| Class                                                      |           |           |          |    |
| rdf:Property                                               |           |           |          |    |
| rdfs:subClassOf                                            |           |           |          |    |
| rdfs:subPropertyOf                                         |           |           |          |    |
| rdfs:domain                                                |           |           |          |    |
| rdfs:range                                                 |           |           |          |    |
|                                                            | Individual | ×          |          |   |
| sameClassAs                                                | ×          |           |          |    |
| samePropertyAs                                             | ×          |           |          |    |
| sameIndividualAs                                           | ×          |           |          |    |
| differentIndividualFrom                                    | ×          |           |          |    |
| inverseOf                                                  | ×          |           |          |    |
| TransitiveProperty                                         | ×          |           |          |    |
| SymmetricProper                                            | ×          |           |          |    |
| FunctionalProperty                                         | ×          |           |          |    |
| InverseFunctionalProperty                                  | ×          |           |          |    |
| allValuesFrom                                              | ×          | toClass    |          |    |
| someValuesFrom                                             | ×          | hasClass   |          |    |
| minCardinality                                             |           |           |          |    |
| maxCardinality                                             |           |           |          |    |
| cardinality                                                |           |           |          |    |
| oneOf                                                      |           | ×          |          |    |
| disjointWith                                               | ×          |           |          |    |
| complementOf                                               | ×          |           |          |    |
| unionOf                                                    | ×          |           |          |    |
| intersectionOf                                             | ×          |           |          |    |
|                                                            | hasValue   | ×          |          |   |
| imports  versionInfo  priorVersion  backwardCompatibleWith | ×  ×  ×  × |       |      |    |

## 5. Conclusion

Ontology language is the basis of ontological knowledge systems, the definition of a system of knowledge representation language specification; it not only has a rich and intuitive ability to express and use it, but the body should be easily understood by the computer, processing and applications. Thus, a brief survey of state-of-the-art ontology languages which are used to express ontology over the Web is provided; all relevant terms were shown in order to provide a basic understanding of ontologies and of description logics, which are the basis of ontology languages. Therefore, choosing a language for building an Ontology is the main step. In other way, different kinds of Ontological knowledge-based applications need different language facilitators for enabling reasoning on Ontology data. These description languages provide richer constructors for forming complex class expressions and axioms. 

6. **REFERENCES**
1. J. Bruijn, "Using Ontologies - enabling knowledge sharing and reuse on the semantic web". Technical Report DERI-2003-10-29, DERI, 2003. Available from http://homepage.uibk.ac.at/»c703239/publicati ons/DERI-TR-2003-10-29.pdf. 

2. A. Grigoris, H.Frank van," Web Ontology Language: OWL. Handbook on Ontologies in Information Systems". Springer-Verlag 2003 3. B. McBride, "The Resource Description Framework (RDF) and its Vocabulary Description Language RDFS, in: The Handbook on Ontologies in Information Systems", S. Staab, R. Studer (eds.), Springer Verlag, 2003. 

4. O. Lassila and R. Swick," Resource Description Framework (RDF) model and syntax specification", 1999. http://www.w3.org/TR/REC-rdf-syntax. 

5. D. Beckett.,"The design and implementation of the Redland RDF application framework". In Proceedings of WWW10 conference, 2001. 

6. W3C Working Group. "W3c resource description framework (rdf) schema specification". 

http://www.w3.org/TR/1998/WD-rdfschema/, March 1999. 