Journal of Computing, Volume 2, Issue 6, June 2010, ISSN 2151-9617 HTTPS://SITES.GOOGLE.COM/SITE/JOURNALOFCOMPUTING/ WWW.JOURNALOFCOMPUTING.ORG 168 relationships between those properties and classes, and it allows combinations between classes, properties, or values. In other words, RDFS is used to define RDF vocabularies. 

In general, RDFS is defined in a namespace informally called 'rdfs', and identified by the URI 
reference http://www.w3.org/2000/01/rdfschema\#. On the other hand, RDF is defined in a namespace informally called 'rdf', and identified by the URI reference http://www.w3.org/1999/02/22-rdf-syntaxns\#. 

Figure 1: Elements of RDF and RDFS [7] 

![0_image_0.png](0_image_0.png)

Figure 1 presents an excellent description of RDF /RDFS elements, demonstrating three important cores: class, property and constraint property. 

In general, an RDF document contains two lists, one of descriptions and one of properties, both of which relate to one resource. Property values could be URIs, literals or others descriptions. 

The rdf:RDF includes a sequence of XML 
elements called rdf:Description, there are 
"rdf:about" and "rdf:ID". In any source we need to use only one of those attributes. rdf:about is used to describe any resource; its value either an absolute or a relative URI. rdf:ID, is used to define a resource; so its value of a fragment to be added to the XML document URI. 

The elements of RDF are Resource, Property, and Property Value which there are: firstly, Resource is anything that can have a URI, 
http://www.dmu.ac.uk/RDF, Property is for named resources such as "university", the property value is the value of a property, such as "De Montfort". For example: 
<?xml version="1.0"?> <RDF> <Description about="http://www.dmu.ac.uk/RDF"> 
 <university>De Montfort</university> <location>UK-Leicester</location> 
 </Description> 
</RDF> 
The statement of RDF is a combination of a resource, a property, and property value forms, as in the statement: "The University of Http://www.dmu.ac.uk/RDF is De Montfort". 

The subject of the statement above is http:// 
www.dmu.ac.uk /RDF. 

The predicate is university. The object is De Montfort. 

Statement: "The location of http://www.dmu.ac.uk/RDF is UK-Leicester". 

The subject of the statement above is: 
http://www.dmu.ac.uk/RDF. 

The predicate is: location. The object is: UK-Leicester. 

## 2.2 **Core Classes**

The elements in this class could be called fundamental concepts because they are used to describe most classes and their properties with examples. This class is defined as part of the RDF Schema vocabulary. 

## 2.2.1 Rdf:Resource

RDF is about describing resources or any objects. Therefore, whatever is described by RDF expressions is called resources; these are always identified by URIs and are considered to be instances of the class rdfs:Resource. 

## 2.2.2 Rdf:Property

rdf:Property is used to represent that subset of RDF resources called properties. 

## 2.2.3. Rdfs:Class

RDF classes are the class of resources used to describe (or which could represent) anything such as cars or persons. When a schema defines a new class, the resource representing that class must have an rdf:type property whose value is the resource rdfs:Class. 

<?xml version="1.0"?> <rdf:RDF 
 xmlns:rdf= "http://www.w3.org/1999/02/22-rdfsyntax-ns\#" 
 xmlns:rdfs="http://www.w3.org/2000/01/rdfschema\#" 
 xml:base= "http://www.cars.fake/cars\#"> <rdfs:Class rdf:ID="cars" /> <rdfs:Class rdf:ID="Benz"> 
 <rdfs:subClassOf rdf:resource="\#cars"/> 
 </rdfs:Class> </rdf:RDF> 

## 2.3. **Core Properties**

These properties are in fact considered as an instances of the class rdf:Property. They are used to provide a mechanism for expressing relationships between classes and super-classes or between classes and their instances. 

## 2.3.1. Rdf:Type

This element is an instance of the RDF 