Journal of Computing, Volume 2, Issue 6, June 2010, ISSN 2151-9617 HTTPS://SITES.GOOGLE.COM/SITE/JOURNALOFCOMPUTING/ WWW.JOURNALOFCOMPUTING.ORG 169 properties used to determine that a resource is an instance of a class. In other words, this shows that a resource is a sub-set of a class, and therefore has all the features that are to be expected of a member of that class. 

## 2.3.2. Rdfs:Subclassof

This property is a transitive relation used to identify a relation between classes as sub/supersets. Classes are therefore structured in a subset hierarchy represented by this property (rdfs:subClassOf) . In other words, this property is used to specify that a class C2 is a subclass of another class C1, with the logical consequence that every instance of C2 is also an instance of C1. 

## 2.3.3. Rdfs:Subpropertyof

This defines any property used to represent a relation between resources. This kind of property is a specialisation relation. rdfs:subPropertyOf is applied to properties to denote that one property is a subset or specialisation of another. 

## 2.3.4. Rdfs:Seealso

The property rdfs:seeAlso used to denote the resources that might either have or provide alternative information about the subject resource over the internet. 

## 2.3.5. Rdfs:Isdefinedby

The property rdfs:isDefinedBy is a subproperty of rdfs:seeAlso, and indicates the resource defining the subject resource. 

## 2.4. **Core Constraints**

These are used to restrict the set of resources that may have a given property (the property's domain) and the set of valid values for a property (its range). A property may have as many values for rdfs:domain as needed, but no more than one value for rdfs:range. 

## 2.4.1. Rdfs:Range & Rdfs:Domain

rdfs:range is used to declare that the values of a property are instances of one or more classes. 

rdfs:domain is used to declare that any resource that has a given property is an instance of one or more classes. 

In the rest of this report, there are some properties used to support user-interface simple documentation these properties relate annotations within RDF schemas. This kind of concept is not essential, but could be useful in any application domain. They are defined in external schemas, but when they came into common use, they were permanently defined in the core schema. 

## 2.4.2. Rdfs:Comment

This is used to add comments to provide a human-readable description of a resource. 

## 2.4.3. Rdfs:Label

 This is used to add a label name to provide a human-readable version of a resource name. 

## 2.4.4. Rdfs:Container

RDF Containers are could be defined as collections of resources. The container nodes are represented by one of the three subclasses of rdfs:Container: rdf:Bag, an unordered collection; rdf:Seq, an ordered collection, and rdf:Alt used to chose between alternatives. 

Although, RDF is a good basic language for many other languages, it is not very expressive and has limitations in describing resources, including descriptions of existence, cardinality, localised range and domain constraints or transitive, inverse or symmetrical properties. In general, as mentioned in [2], RDFS's expressive power is limited; on other hand, RDF/ RDFS 
provide modelling that concerns organisation of vocabularies in term of hierarchies: subclass and sub-property relationships, domain and range restrictions, and instances of classes. However, some features are still missing like specialised or defined properties of local scope and the specialisation of their characteristics of properties. It is impossible to separate some classes from each other. For example, we cannot say male and female are disjoint. But RDF Schema can only cater for subclass relationships - 
e.g. female is a subclass of person. On other hand, it is impossible to combine or create classes using Boolean relations. The expression of many restrictions is limited. The need consequently arose for a new language to supply all these deficiencies. 

There are also many limitations to RDFS, 
among which are its inability to express equality and inequality, and its limited ability to define enumeration of property values. Regarding the latter, it cannot describe some relation among entities like union, intersection, complement, unique, symmetric, transitive, and inverse, and as far as constraints go it cannot apply cardinality and existence. Domain and range can only be specified globally. As a result, several languages such as OWL, DAML+OIL have been developed to meet these limitations. 

## 3. Annotated Daml+Oil **Ontology** Mark-Up

DARPA Agent Markup Language (DAML) + 
Ontology Inference Layer (OIL), DAML+OIL [8, 9] is a semantic mark-up language designed for use for Web resources. In fact, it has been built on RDF and RDF Schema, which is to say that it has an RDF/XML syntax based on the frame paradigm, and so DAML+OIL could be considered as a specific kind of RDF and this 