Journal of Computing, Volume 2, Issue 6, June 2010, ISSN 2151-9617 HTTPS://SITES.GOOGLE.COM/SITE/JOURNALOFCOMPUTING/ WWW.JOURNALOFCOMPUTING.ORG 170 language then extended with more richer modelling primitives to cope with weaknesses in RDF /RFDS. To this end it uses URI to define the resources as RDF. DAML+OIL was actually developed to describe the structure of a domain, as most web-based languages describe structure in terms of classes and properties. DAML+OIL 
uses a Description Logic style model theory to formalise the meaning of a language [15]. 

Research first produced the Ontology Inference Layer (OIL), and a further effort produced DAML+OIL, an amalgamation of the American proposal DAML-ONT5, and the European language OIL. 

## 3.1. **Ontology Interchange Languages** (Oil)

A semantic mark-up language for Web semantics has been built on RDF and RDF/S, this language providing modelling primitives used in frame based and Description Logic oriented Ontologies [14]. 

The following illustrate elements that could appear in DAML+OIL documents: 

## 3.2. **Setting Up Namespaces**

Because of DAML+OIL is written in RDF, and RDF is written in XML, DAML+OIL exploits the existing Web standards XML and RDF, so a DAML+OIL document start with several namespace declarations using RDF, XML 
Namespace, and URIs. 

 
<rdf:RDF 
 xmlns:rdf ="http://www.w3.org/1999/02/22-rdfsyntax-ns\#" 
 xmlns:rdfs="http://www.w3.org/2000/01/rdfschema\#" 
 xmlns:xsd 
="http://www.w3.org/2000/10/XMLSchema\#" 
 xmlns:daml="http://www.w3.org/2001/10/daml+oil\#" 
 xmlns:dex ="http://www.w3.org/TR/2001/NOTEdaml+oil-walkthru-20011218/daml+oil-ex\#" 
 xmlns:exd ="http://www.w3.org/TR/2001/NOTEdaml+oil-walkthru-20011218/daml+oil-ex-dt\#" xmlns ="http://www.w3.org/TR/2001/NOTEdaml+oil-walkthru-20011218/daml+oil-ex\#" > 
</rdf:RDF>. 

## 3.3. **Housekeeping**

The first declaration after the namespace that is an Ontology. This assertion is formulaic; the 
"about" attribute will typically be empty, indicating that the subject of this declaration is this document. For documentation purposes a few properties of this Ontology are given, such as daml:versionInfo, rdfs:comment, daml:imports 
<daml:Ontology rdf:about=""> 
 <daml:versionInfo>$Id: daml+oil-ex.daml,v 1.8 2001/03/27 21:24:04 vehicle Exp $ </daml:versionInfo> 
 <rdfs:comment> An example vehicle Ontology </rdfs:comment> <daml:imports rdf:resource="http://www.w3.org/2001/10/daml+oil"/> <rdfs:label> vehicle </rdfs:label> </daml:Ontology> 

## 3.4. **Defining Classes**

The first step in Ontology definitions is to describe objects. It is useful to define some basic types. In DAML+OIL, classes are defined by using a daml:Class element which is a subclass of rdfs:Class. 

This is done by giving a name for the class, which is the subset of the universe which contains all objects of that type. 

 
<daml:Class rdf:ID="Cars"> <rdfs:label>Cars</rdfs:label> <rdfs:comment> This class of cars is illustrative of a number of ontological idioms. </rdfs:comment> </daml:Class> 
This asserts that there is a class known as car. 

DAML+OIL divides the word into objects 
(which are elements of DAML classes) and datatype values. Data-type values are used to help define classes, but they are not DAML objects and cannot be included in a DAML object class. 

There are a number of types of car, including Mercedes- BENZ and BMW. 

<daml:Class rdf:ID="BENZ"> <rdfs:subClassOf rdf:resource="\#Cars"/> 
</daml:Class> 
<daml:Class rdf:ID="BMW"> <rdfs:subClassOf rdf:resource="\#Cars"/> <daml:disjointWith rdf:resource="\#BENZ"/> </daml:Class> 
This means that these two classes are disjoint 
(using the disjoint with tag): nothing can be both. It perfectly admissible for a class to have multiple superclasses: E-Class is a Car and Mercedes -BENZ. 

<daml:Class rdf:ID="E-Class"> <rdfs:subClassOf rdf:resource="\#Cars"/> 
 <rdfs:subClassOf rdf:resource="\# Mercedes-BENZ"/> 
</daml:Class> 

## 3.5. **Defining Properties**

Properties are used to define binary relations between items. Properties in this language are of two kinds: the first, "daml:ObjectProperty", defines relations between objects, and the second, daml:DatatypeProperty, defines relations between objects and their data-type values. It can be said that domains and ranges are global 