Journal of Computing, Volume 2, Issue 6, June 2010, ISSN 2151-9617 HTTPS://SITES.GOOGLE.COM/SITE/JOURNALOFCOMPUTING/ WWW.JOURNALOFCOMPUTING.ORG 171 information about properties. 

<daml:ObjectProperty rdf:ID="hasCar"> 
 <rdfs:domain rdf:resource="\#Person"/> <rdfs:range rdf:resource="\#Car"/> </daml:ObjectProperty> 
In general, properties that relate object properties to datatype values are members of DatatypeProperty. Strings, integers or decimal numbers are sometimes used when dealing with DatatypeProperty, which lead to such references as standard location XML Schema datatype decimal [8]. So for example to create an age property, non-negative integers must be mapped into XML Schema [9]. 

<daml:DatatypeProperty rdf:ID="age"> <rdfs:comment> 
 age is a DatatypeProperty whose range is xsd:decimal. age is also a UniqueProperty (can only have one age) </rdfs:comment> <rdf:type rdf:resource="http://www.w3.org/2001/10/daml+oil\#U
niqueProperty"/> <rdfs:range rdf:resource="http://www.w3.org/2000/10/XMLSchema \#nonNegativeInteger"/> </daml:DatatypeProperty> 

## 3.6. **Defining Property Restrictions**

The property restriction is used to define an anonymous class, which contains all objects or things that satisfy the restriction. The following example defines an anonymous class of PhD 
student who has only a car. 

<daml:Class rdf:ID="PhD Student"> <rdfs:subClassOf rdf:resource="\#UniverstyStudentl"/> <rdfs:subClassOf> <daml:Restriction> 
 <daml:onProperty rdf:resource="\#hasCar"/> 
 <daml:toClass rdf:resource="\#PhDStudent"/> 
 </daml:Restriction> </rdfs:subClassOf> 
A requirement of any web Ontology language is that statements about entities can be distributed along with different locations. 

<daml:Class rdf:about="\#PhD Student"> <rdfs:comment> PhD Student has exactly two supervisors, ie: </rdfs:comment> 
 <rdfs:subClassOf> <daml:Restriction daml:cardinality="2"> 
 <daml:onProperty rdf:resource="\#hasSupervisor"/> </daml:Restriction> </rdfs:subClassOf> 
</daml:Class> 
The cardinality property specifies a precise cardinality. But sometimes the cardinality must be restricted without being precisely specified. A 
person may have zero or one wife, but no more: 
<daml:Class rdf:about="\#Person"> 
 <rdfs:subClassOf> <daml:Restriction daml:maxCardinality="1"> <daml:onProperty rdf:resource="\#haswife"/> </daml:Restriction> </rdfs:subClassOf> </daml:Class> 
A minimal value for the cardinality of a property can be expressed thus: <Restriction daml:minCardinality="0">. A cardinality constraint could specify a maximum, minimum or precise number of values as well as enforcing the type of property those values must have. 

## 3.7. **Notations For Properties**

In fact, several annotations are used in this proposal to illustrate various notations for properties: 
<daml:UniqueProperty rdf:ID="hasMother"> 
 <rdfs:subPropertyOf rdf:resource="\#hasParent"/> <rdfs:range rdf:resource="\#Female"/> </daml:UniqueProperty> 
The (inverseOf) tag. 

<daml:ObjectProperty rdf:ID="hasChild"> 
 <daml:inverseOf rdf:resource="\#hasParent"/> </daml:ObjectProperty> 
The transitive tag: <daml:TransitiveProperty rdf:ID="hasAncestor"> <rdfs:label>hasAncestor</rdfs:label> </daml:TransitiveProperty> 
 <daml:TransitiveProperty rdf:ID="descendant"/> 
Sometimes, "mom" is used as a synonym for 
"mother". The tag samePropertyAs allows this synonymy to be established: 
<daml:ObjectProperty rdf:ID="hasMom"> <daml:samePropertyAs rdf:resource="\#hasMother"/> </daml:ObjectProperty> 

## 3.8. **Notations For Classes**

The following example represents the class 
"car" as being disjointed from the class "person", 
through use of the complementOf tag: 
<daml:Class rdf:ID="Car"> <rdfs:comment>no car is a person</rdfs:comment> <rdfs:subClassOf> 
 <daml:Class> 
 <daml:complementOf rdf:resource="\#Person"/> 
 </daml:Class> </rdfs:subClassOf> </daml:Class> 
A class disjointly united with a set of other classes can also be recognised. In this case, the class "person" can be identified with the disjoint 