Journal of Computing, Volume 2, Issue 6, June 2010, ISSN 2151-9617 HTTPS://SITES.GOOGLE.COM/SITE/JOURNALOFCOMPUTING/ WWW.JOURNALOFCOMPUTING.ORG 172 union of the classes "man" and "woman". 

<daml:Class rdf:about="\#Person"> 
 <rdfs:comment>every person is a man or a woman</rdfs:comment> <daml:disjointUnionOf rdf:parseType="daml:collection"> 
 <daml:Class rdf:about="\#Man"/> <daml:Class rdf:about="\#Woman"/> 
 </daml:disjointUnionOf> </daml:Class> 
The parseType="daml:collection" indicates that these sub-elements are to be treated as a unit. 

 <daml:Class rdf:ID="ElegantWoman"> <daml:intersectionOf rdf:parseType="daml:collection"> <daml:Class rdf:about="\#ElegantThing"/> 
 <daml:Class rdf:about="\#Woman"/> 
 </daml:intersectionOf> 
 </daml:Class> 

## 3.9. **Defining Individuals**

Individual objects in a class can also be identified, for example Adam, a person of age 13 and shoesize 9.5: 
<Person rdf:ID="Adam"> <rdfs:label>Adam</rdfs:label> 
 <rdfs:comment>Adam is a person.</rdfs:comment> 
 <age><xsd:integer rdf:value="13"/></age> 
 <shoesize><xsd:decimal rdf:value="9.5"/></shoesize> </Person> 
This datatype is used to parse the lexical representation into an actual value. A person has a property called hasSize, which is a size. 

<daml:ObjectProperty rdf:ID="hasSize"> <rdfs:range rdf:resource="\#Size"/> </daml:ObjectProperty> 
Height is a class described by an explicitly enumerated set, which can be described using the oneOf element. Like disjointUnionOf, oneOf uses the RDF-extending parsetype="daml:collection". 

<daml:Class rdf:ID="Size"> 
 <daml:oneOf rdf:parseType="daml:collection"> < Size rdf:ID="small"/> < Size rdf:ID="medium"/> < Size rdf:ID="large"/> 
 < Size rdf:ID="Extralarge"/> 
 </daml:oneOf> </daml:Class> 
Finally, TallThing is the class of objects or things whose hasSize has the value tall: 
<daml:Class rdf:ID="TallThing"> <daml:sameClassAs> 
 <daml:Restriction> 
 <daml:onProperty rdf:resource="\# hasSize "/> <daml:hasValue rdf:resource="\#tall"/> </daml:Restriction> </daml:sameClassAs> </daml:Class> 
DAML+OIL has many limitations [17]: 
property constructors, it has no composition or transitive closure, in property types contain transitive and symmetrical, sets are the only collection type in this language (there are no bags or lists), there is no aggregation or comparison in data value, it has only unary and binary relations, and there are neither defaults value or nor variables. 

## 4. **Web Ontology Language (Owl)**

Web Ontology Language (OWL) [2, 10, 11, 12, 13], which is a language for processing web information, became a W3C (World Wide Web Consortium) Recommendation in February / 2004. It has been built using RDF to remedy the weaknesses in RDF/S and DAML+OIL. It provides a richer integration and interoperability of data among communities and domains. 

It can be said that there is a similarity between OWL and RDF, but the former is a stronger syntax with more machine interpretability and vocabulary language than RDF. Obviously, RDF 
is generally limited to binary ground predicates, and RDF Schema also has the limitation that it represents a subclass hierarchy and a property hierarchy, with the domain and range definitions of these properties. In other words, the language of OWL is more expressive than that of RDF and RDF Schema. 

To cope with limitation in RDF, RDF/S and DAML+OIL, W3C's defined OWL. Indeed, OWL 
is an extension of RDFS; in other words, OWL 
builds on RDF and RDF Schema, and uses RDF' 
XML syntax; overall, OWL uses the RDF 
meaning of classes and properties. W3C's classify OWL into three sublanguages, each of which is intended to supply different aspects of these incompatibilities. OWL's sub-languages are OWL Full, OWL Lite, and OWL DL. What follows is a brief description of these sublanguages. 

OWL documents are usually called OWL 
Ontologies, some elements of which are: 

## 4.1. **Setting Up Namespaces**

Because OWL is written in RDF, and RDF is written in XML, (in other words, OWL exploits the existing Web standards XML and RDF), so OWL documents start with several namespace declarations using RDF, XML Namespace, and URIs. rdf:RDF is the root element of a OWL 
Ontology, and also specifies a number of namespaces. 