Journal of Computing, Volume 2, Issue 6, June 2010, ISSN 2151-9617 HTTPS://SITES.GOOGLE.COM/SITE/JOURNALOFCOMPUTING/ WWW.JOURNALOFCOMPUTING.ORG 173 <rdf:RDF xmlns:owl ="http://www.w3.org/2002/07/owl\#" 
 xmlns:rdf ="http://www.w3.org/1999/02/22-rdfsyntax-ns\#" 
 xmlns:rdfs="http://www.w3.org/2000/01/rdfschema\#" 
 xmlns:xsd ="http://www.w3.org/2001/XLMSchema\#"> 
After rdf:RDF, some declarations to identify namespaces associated with this Ontology could be added. The effect of all of these namespaces is that such prefixes as owl and rdf should be understood as referring to things drawn from following namespaces, as for example http://www.w3.org/2002/07/owl\#. 

## 4.2. **Housekeeping**

After namespaces are established, any Ontology written in OWL may start with a collection of assertions for house-keeping purposes. These assertions are grouped under an owl:Ontology element which may contain comments, version statements, imports other Ontologies and labels, for example: 
<owl:Ontology rdf:about=""> <rdfs:comment>An example Currency Ontology </rdfs:comment> <owl:versionInfo>$Id: http://www.daml.ecs.soton.ac.uk/ont/currency.owl, v 1.0 trp 2007/06/13 10:35:25 Exp $</owl:versionInfo> 
 <owl:imports rdf:resource="http://www. kkkkkkkkk"/> <rdfs:label> Currency Ontology </rdfs:label> </owl:Ontology> 
The rdf:about attribute provides a reference for the Ontology. Where the value of the attribute is "", which is the standard case, rdfs:comment is used to provide a humanreadable description of a resource. rdfs:label is used to provide a human-readable version of a resource name. 

The versioning information 
"owl:priorVersion" which is part of the header information used to indicate earlier versions of the current Ontology. In fact, Ontologies are similar to any software that can be maintained or changed over time. There are three kinds of versioning information statement; none of them carry any formal meaning, but can be exploited by human readers: 
- An owl:versionInfostatement generally contains a string giving information about the current version. 

- An owl:backwardCompatibleWith statement contains a reference to another Ontology. 

- An owl:incompatibleWith indicates that the Ontology containing is a later version of the Ontology referred to, but is not backward compatible with it. 

## 4.3. **Defining Classes**

In OWL, classes are defined by using an owl:Class element that is a subclass of rdfs:Class. 

For example, a class "cars" is as follows: 
<owl:Class rdf:ID="Cars"> 
 <rdfs:label>Cars</rdfs:label> 
 <rdfs:comment> This class of cars is illustrative of a number of ontological idioms. </rdfs:comment> </owl:Class> 
One of the power elements of OWL is a 
"owl:disjointWith", which is missing from RDFS, and is used to disjoint one class from others. 

"owl:equivalentClass" is another element that could be used used to establish equivalence between classes. Last but not last, there are two predefined classes, owl:Thing (which defines everything) and owl:Nothing, which is empty set. 

## 4.4. **Defining Properties**

There are two kinds of properties in OWL. 

Object properties represent the relation between two objects, such as the relation (isOwnBy, own) 
used to represent the relation between car and person. Datatype properties represent the related objects with their data-type values such as person with phone, address and age. 

<owl:ObjectProperty rdf:ID="isOwnBy"> <owl:domain rdf:resource="\#car"/> <owl:range rdf:resource="\#person"/> </owl:ObjectProperty> 
In OWL it is possible to talk about Boolean combinations such as union, intersection, or complement of classes. For example it can be said that people in Jordan are Muslims or Christians. 

<owl:Class rdf:ID="peopleAtJordan"> <owl:unionOf rdf:parseType="Collection"> <owl:Class rdf:about="\# Muslims "/> 
 <owl:Class rdf:about="\# Christians "/> 
 </owl:unionOf> </owl:Class> 
Some Boolean relations are supported by OWL; to declare more than one domain and range, the Boolean relational must be used. One example would be intersection and union among others, as well as inverse properties to inherit domain and range. Another element in OWL, 
owl:equivalentProperty, is used to define the equivalence of two classes and their properties, whereclasses have the same instances. 

<owl:Class rdf:ID="Cars"> <owl:equivalentClass rdf:resource="Automobile"/> </owl:Class> 