Journal of Computing, Volume 2, Issue 6, June 2010, ISSN 2151-9617 HTTPS://SITES.GOOGLE.COM/SITE/JOURNALOFCOMPUTING/ WWW.JOURNALOFCOMPUTING.ORG 174 This is a strong relation used to map between two Ontologies. 

## 4.5. **Defining Property Restrictions**

OWL uses some properties to add specification by using some properties' restriction to classes. These restrictions are used to define an anonymous class that will contain all things or objects that satisfy the restriction. For example, owl:allValuesFrom is used to specify the class of possible values, and owl:onProperty is used to specify the property. The next example illustrates that every car should be driven by a professional driver. 

<owl:Class rdf:about="\#everycar "> <rdfs:subClassOf> 
 <owl:Restriction> 
 <owl:onProperty rdf:resource="\#isDriveBy"/> <owl:allValuesFrom rdf:resource="\#professionaldrivers "/> </owl:Restriction> </rdfs:subClassOf> 
</owl:Class> 
Another and similar property is owl:hasValue, which declares a specific value that the specified property must have. For example, a car should be driven by a person. 

<owl:Class rdf:about="\#car"> 
 <rdfs:subClassOf> 
 <owl:Restriction> 
 <owl:onProperty rdf:resource="\#isDrivenBy"/> <owl:hasValue rdf:resource="\#person"/> </owl:Restriction> </rdfs:subClassOf> 
</owl:Class> 

## 4.5.1. **Special Properties**

There are some other properties of property elements that can be defined directly: 
owl:TransitiveProperty defines a transitive property, such as "is older than", meaning among other things "the ancestor of", owl:SymmetricProperty defining a symmetric property such as "is sibling of", owl:FunctionalProperty, defining a property that has at most one unique value for each object such as age or National Insurance Number, and owl:InverseFunctionalProperty, which defines a property for which two different objects cannot have the same value, such as National Insurance Number. 

<owl:ObjectProperty rdf:ID="isSiblingOf "> 
 <rdf:type rdf:resource="&owl;TransitiveProperty" /> <rdf:type rdf:resource="&owl;SymmetricProperty" /> <rdfs:domain rdf:resource="\#person" /> <rdfs:range rdf:resource="\#person" /> 
</owl:ObjectProperty> 
Also, 
<owl:ObjectProperty rdf:ID="own"> <rdfs:range rdf:resource="\#car"/> <rdfs:domain rdf:resource="\#person"/> <owl:inverseOf rdf:resource="\#isOwnBy"/> </owl:ObjectProperty> 
The rdf:parseType attribute is shorthand for an explicit syntax for building lists with 
<rdf:first> and <rdf:rest> tags. 

<owl:Class rdf:ID="MuslimsAtJordan"> 
 <owl:intersectionOf rdf:parseType="Collection"> < owl:Class rdf:ID="peopleAtJordan"> <owl:complementOf> <owl:unionOf rdf:parseType="Collection"> 
 <owl:Class rdf:about="\# Christians "/> 
 <owl:Class rdf:about="\#OtherReligion"/> 
 </owl:unionOf> </owl:complementOf> </owl:intersectionOf> 
</owl:Class> 

## 4.6. **Enumerations**

owl:oneOf is an enumeration element, used to define a class by listing all its elements. 

<owl:oneOf rdf:parseType="Collection"> <owl:Thing rdf:about="\#January "/> <owl:Thing rdf:about="\#February "/> : : 
 <owl:Thing rdf:about="\#Desember"/> 
</owl:oneOf> 

## 4.7. **Instances**

These are instances of classes, and are defined in the same way as in RDF. For example, the National Insurance Number for one individual could be present thus: 
<rdf:Description rdf:ID="9801002839"> <rdf:type rdf:resource="\#person"/> </rdf:Description> 
Another format could define this so: <person rdf:ID="9801002839"/>. Indeed, further details can also be added, such as: 
<person rdf:ID="9801002839"/> <uni:age rdf:datatype="&xsd;integer">27<uni:age> </person > 
Also, 
<carplat rdf:about="CI123TR"> 
 <isOwntBy rdf:resource=" 9801009493"> <isOwntBy rdf:resource="9672006574"> </course> 

## 4.8. **The Core Of Owl Language**

This description language contains three expressive sublanguages. These sublanguages are OWL Lite, OWL DL, and OWL Full [1]. 