ontology. "Ontology provides a formal, explicit specification of a shared conceptualisation of a domain" [31, 36]. 

Therefore, it facilitates knowledge sharing over distributed systems; in other words, it allows systems or applications to cooperate that were not formerly designed to interoperate. Ontology plays a major part in solving the problem of interoperability between applications across different organizations, by providing a shared understanding of common domains. Several Ontologies have recently been built. Consequently, they should be accessed from other applications for use or information exchange. Ontologies in such numbers present interoperability problems, for which many solutions have been developed. One of these is to build a single Ontology, but this is inadequate, partly because it is too inflexible for knowledge sharing. Another solution is Ontology Mapping which plays an important role in solving interoperability in heterogeneous systems and in many application domains. This way is to build bridges between Ontologies in order to provide commonly accessible layers that could then exchange information in semantically sound ways. Therefore, in the following sections, this paper will describe many terminologies in order to understand the Semantic Web and Ontologies. 

## 2. **Web Service**

A web service [36] is a self-describing software program using self-contained applications and identified by a Uniform Resource Identifier (URI), used to share information between applications over the Internet. Access to and retrieval of information from the Web occurs via the HTTP protocol. One of the first languages to have been used for the internet is HTML, a markup language used to describe the document structure. The Web can be conceived as a huge library containing a large amount of information or data - unfortunately without any sensible means of representation. The common Web service scenario [36] can be described by the three actions of publish, bind and find, and three actors: the service requester, the service provider and the registry, where services can be published, advertised and sometimes located. In other words, service providers describe and advertise their services in the registry, while service requesters search the registry for services that match their requirements. 

There are obviously many examples of Web services, including: 
 Credit card authorisation. 

 Currency converter (e.g. dollars to Euros). 

 Stock quote provider. 

 Shipping rate calculator. 

## 3 **Semantic Web**

The S**emantic Web [36]** is distributed and heterogeneous, has brought the evolution of the Web to a higher level. There are two visions of the future in the development of the Web, the first being to improve its usability as a medium for collaboration and the second to ensure that its contents can be understood by machines. Providing annotation data will facilitate this second aim. 

Tim Berners-Lee, who invented the WWW 
and has worked on the Semantic Web, states that the latter "is not a separate Web but an extension of the current one, in which information is given a well-defined meaning, better enabling computers and people to work in cooperation." [2]. Thus, the Semantic Web [16, 31] is distinguished by a more meaningful representation of information for humans and computers, providing a description of its contents and services in machine-readable form; moreover, it enables services to be automatically annotated, discovered, published, advertised and composed. It thereby facilitates interoperability and the sharing of knowledge over the Web. Its main goal is therefore to make information on the Web accessible and understandable by humans and computers. Figure 1 illustrates the architecture of the Semantic Web. 