In fact, both the Semantic Web and Web 

![0_image_0.png](0_image_0.png) services are considered to be a set of resources, identified by the URI. The difference between them is that Web services use HTTP to display the contents of a page, while the Semantic Web tries to create machine readability by semantically representing the data or information in resources. Numerous tools and applications of Semantic Web technologies have recently become available. The layers of architecture represented [2, 16, 31, 36, 35] in Figure 1 are briefly described below: 
 **URI and Unicode:** To identify and locate resources, or indeed anything on the Web, a uniform system of identifiers (URIs) is used. The URI, 
which is considered to be the foundation of the Web, is used to give a unique name to each resource. Unicode is the standard for computer character representation. 

 **Extensible Markup Language (XML**) 
is a markup language, which means that it is machine-readable and has its own format. It is widely known in the WWW community because it has a flexible text format and was designed to describe data and to meet the challenges of large-scale e-business and electronic publishing; it plays an important role in exchanging different types of data on the Web. In fact, it is the basis of a rapidly growing number of software development activities. Each document starts with a namespace declaration using XML Namespace. 

 The Resource Description Framework 
(RDF) is the first layer of the Semantic Web. RDF is a framework for using and representing metadata and describing the semantics of information about resources on the Web in a machine-accessible way. It uses URIs to identify Web resources and to describe the relations between these resources, using a graph model. 

While describing classes of resources and the properties between them, using RDF Schema (which is a simple modelling language), it also provides a simple reasoning framework for inferring types of resources. 

 **Ontology Vocabulary** is a language which provides a common vocabulary and grammar for published data as well as a semantic description of the data used to preserve the ontologies and to keep them ready for inference. Ontology means describing the semantics of the data, providing a uniform way to enable communication by which different parties can understand each other. 

 **Logic and Proof:** In the Semantic Web, the building of systems follows a logic which considers the structure of ontology. A reasoner could be used to check and resolve consistency problems and the redundancy of the concept translation. A reasoning system is used to make new inferences. 

 **Trust** is the final layer of the Semantic Web. This component concerns the trustworthiness of the information on the Web in order to provide an assurance of its quality. 

## 4 Ontology

Ontologies [27], which are used in order to support interoperability and common understanding between the different 