"Jordan" could be an instance of the class "Arab countries" or simply "countries". 

 **A Relation** (also known as a slot) is used to express relationships between two concepts in a given domain. More specifically, it describes the relationship between the first concept, represented in the domain, and the second, represented in the range. For example, "study" could be represented as a relationship between the concept "person" (which is a concept in the domain) and "university" or "college" 
(which is a concept in the range). 

 **An Axiom** is used to impose constraints on the values of classes or instances, so axioms are generally expressed using logic-based languages such as first-order logic; they are used to verify the consistency of the ontology. 

## 4.2 **Structure Of Ontology**

In general, the structure of an ontology [28] is described as a 5‐*tuple* O: = (C, HC, R, HR, I), where C represents a set of concepts (instances of "*rdf:Class*").

These concepts are arranged with a corresponding subsumption hierarchy HC.

 R represents a set of relations that relate concepts to one another (instances of "*rdf:Property*"). Ri R and Ri  C × C.
 HC represents a concept hierarchy in the form of a relation (a binary relation corresponding to "*rdfs:subClassOf*").  HC
 C × C, where HC (C1, C2) denotes that C1 is a subconcept of C2.

 HR represents a relation hierarchy in the form of a relation HR  R×R, where HR (R1, R2)
denotes that R1 is a subrelation of R2("*rdfs:subPropertyOf*").
 I is the instantiation of the concepts in a particular domain ("*rdf:type*").

In general, there are many ways to represent or model the classification of concepts semantically. These include taxonomies, thesauri and ontologies. These widely varying concepts are used in Web semantics, which is why it is necessary to apply taxonomy, or the science of identifying and arranging vocabulary in the shape of a hierarchy or tree. In other words, it is used to describe concepts and their relationships explicitly. The relationships of "subclass" and "super-class" are the taxonomic ones that could be used. 

A thesaurus [26] is a vocabulary with conceptual relationships between the terms and can be considered an extension of taxonomy with richer semantic relationships. It can easily be converted into a taxonomy, but expressiveness and semantics will be lost. The relationships which could be used in a thesaurus are equivalence, homography, hierarchy and association. 

Ontologies are like taxonomies but with more semantic relationships between concepts and attributes; they also contain strict rules used to represent concepts and relationships. An ontology is a hierarchically structured set of terms for describing a domain that can be used as a skeletal foundation for a knowledge base. 

According to this definition, the same ontology can be used for building several knowledge bases, which would share the same skeleton or taxonomy. The ontology community distinguishes ontologies that are mainly taxonomies from those that model the domain in a deeper way and provide more restrictions on domain semantics. The community calls them lightweight and heavyweight 