
## 4.4.2 **Ontology Merging**

Ontology merging [20, 23, 30] is the process of creating a new single coherent ontology from two or more existing source ontologies related to the same domain. The new ontology will replace the source ontologies. 

## 4.4.3 **Ontology Integration**

Integration [23, 30] is the process of creating a new ontology from two or more source ontologies from different domains. 

## 4.4.4 **Ontology Mapping**

Ontology mapping [19, 22, 29, 32, 34] is a formal expression or process that defines the semantic relationships between entities from different ontologies. In other words, it is an important operator in many ontology application domains, such as the Semantic Web and e-commerce, which are used to describe how to connect and from correspondences between entities across different ontologies. Ontology matching is the process of discovering similarities between two ontologies. An entity e is understood in an ontology O 
denoted by e|O is concept C, relation R, or instance I, i.e. e|O  C  R  I. Mapping the two ontologies, O1 onto O2, means that each entity in ontology O1 is trying to find a corresponding entity which has the same intended meaning in ontology O2. 

The Ontology mapping function "map" is defined based on the vocabulary, E, of all terms e  E and based on the set of possible ontologies, O as a partial function: 
map: E × O × O ֊ E, *with* e  O1(   f O2 : map(e,O1,O2) = f  
map(e,O1,O2) = ).

An entity is mapped to another entity or none.

## 4.4.5 **Ontology Alignment**

Ontology alignment [12, 13, 14, 24] is the process or method of creating a consistent and coherent link between two or more ontologies by bringing them into mutual agreement. This method is near to artificial intelligence methods: being a logical relation, ontology alignments are used to clearly describe how the concepts in the different ontologies are logically related. 

This means that additional axioms describe the relationship between the concepts in different ontologies without changing the meaning in the original ontologies. 

In fact, ontology alignment uses as preprocess for both ontology merging and ontology integration. 

There are many different definitions of ontology alignment, depending upon its application and its intended outcome. 

Sample definitions include the following: 
 Ontology alignment is used to 
"establish correspondences among the source ontologies, and to determine the set of overlapping concepts, concepts that are similar in meaning but have different names or structure, and concepts that are unique to each of the sources" [30]. 

 Ontology alignment is the process of bringing two or more ontologies into mutual agreement, making them consistent and coherent [7, 10, 33]. 

 "Given two ontologies O1 and O2, mapping one ontology onto another means that each entity (concept C, relation R, or instance I) in ontology O1 is trying to find a corresponding entity (i.e. by using matching algorithms), which has the same intended meaning, in ontology O2" [11]. 

Formally, an ontology alignment function is defined as follows: 
An ontology alignment function, align, based on the set E of all entities e  E and based on the set of possible ontologies O, is a partial function. 

Align: O1  O2 Align (eO1) = fO2  if Sim(eO1, fO2) >
threshold.