# Grouplingam: Linear Non-Gaussian Acyclic Models For Sets Of Variables

Yoshinobu Kawahara,1 Kenneth Bollen,2 Shohei Shimizu1 **and Takashi Washio**1 Abstract: **Finding the structure of a graphical model has been received**
much attention in many fields. Recently, it is reported that the nonGaussianity of data enables us to identify the structure of a **directed**
acyclic graph without any prior knowledge on the structure. In this paper, we propose a novel non-Gaussianity based algorithm for **more general type of models; chain graphs. The algorithm finds an ordering of**
the disjoint subsets of variables by iteratively evaluating the independence between the variable subset and the residuals when the **remaining**
variables are regressed on those. However, its computational cost grows exponentially according to the number of variables. Therefore, we further discuss an efficient approximate approach for applying the algorithm to large sized graphs. We illustrate the algorithm with artificial and realworld datasets.

## 1. Introduction

In order to discover or understand data generating mechanisms, **a graphical**
model has been used as a fundamental tool, and the problem of finding its structure from data has been received much attention in many fields including social sciences
[1], bioinformatics [9] and neuroinformatics [8].

Among variety of models, structural equation models (SEMs) and Bayesian networks (BNs) have been widely used to analyze causal relationships in **empirical**
studies [1, 10, 13]. However, the full structure, i.e., a causal ordering and connection strengths, of the model cannot be identified in most cases **without prior**
knowledge on the structure when only covariance structure of data is used for model estimation as is the case in almost conventional methods. Recently, it is reported that non-Gaussian structure of data overcomes this identifiability problem in the case of linear directed acyclic graphs (DAGs) [11, 12]. By their algorithms (the LiNGAM algorithms), if the external influences are non-Gaussian, the structure can be uniquely estimated by using observed data only without any prior knowledge (under an assumption of acyclicity).

However, the applicability of the LiNGAM algorithms might be restricted in some real-world applications because of its relatively strong assumptions of linear acyclicity in each variable. For example, in the cases where an unobserved confounder exists between exogenous variables or sink variables, a DAG structure is no longer appropriate to apply. Thus, it would be useful to develop a non-Gaussianity based framework to estimate the structure of more general class of models, such as chain graphs [7], so as to deal with the situations under which the assumptions on 1The Institute of Scientific and Industrial Research (ISIR), Osaka University.

E-mail: {kawahara,sshimizu,washio}@ar.sanken.osaka-u.ac.jp 2Department of Sociology, The University of North Carolina.

E-mail: bollen@unc.edu 1 arXiv:1006.5041v1 [cs.AI] 24 Jun 2010