DAGs are not satisfied. Note that there is a method based on non-Gaussianity that takes unobserved confounders into account [4]. However, since this method needs to model unobserved variables explicitly, the computational cost is **crucially high** (In fact, only two or three variables were empirically treated in the paper).

In this paper, we propose a non-Gaussian variant of chain graphs, **which includes the one of linear acyclic graphs as a special case, and present an algorithm**
for the estimation of this model. The algorithm finds an ordering of the subsets of variables by iteratively evaluating the independence between the **variable subset** and the residuals when the remaining variables are regressed on those. In addition to the applicability to chain graphs, it is empirically verified that the estimation by the proposed algorithm works reasonably well compared with the **existing algorithms when applied to DAGs. However, this procedure needs to compute the**
independence exponentially many times corresponding to the number of variables. Therefore, we propose an approximate approach that can be performed without depending on the number of variables (although the accuracy may depend on) and can be applied to large scale graphs. The performance will be illustrated using artificial and real-world datasets.

The reminder of this paper is organized as follows. In Sect. 2, we first introduce a linear non-Gaussian acyclic model for sets of variables (GroupLiNGAM
model). Then in Sect. 3, we present an algorithm for (directly) estimating the GroupLiNGAM model. However, this approach would be inefficient for large sized graphs. Therefore, in Sect. 4, we give an approximate approach that can be applied to large sized graphs based on the algorithm described in Sect. 3. The algorithms are illustrated and examined in its performance using artificial data in **Sect. 5 and**
real-world data in Sect. 6. Finally, we give conclusions in Sect. 7.

## 2. Grouplingam Model

In this paper, we consider a non-Gaussian variant of chain graphs, **which we call**
the **GroupLiNGAM model**.

Assume that observed data are generated from a process represented graphically by a chain graph on random variables x of dimension p**. Let us express this chain**
graph by a p × p adjacency matrix B = {bij}, where every bij **represents the** connection strength from a variable xj to another xi**in the chain graph. Also, let**
K(l) (l = 1, . . . , m, m ≤ p) be ordered blocks, i.e.**, disjoint subsets of variables,**
so that no variables in later subsets influence any variable in earlier subsets and K(1) ∪ · · · ∪ K(m) = V , where V := {1, . . . , p} **is the indices set of the variables.**3 The index of the subset, i.e., l, that xi belongs to will be referred as l(i**). Moreover,**
assume that the relations between variables in different subsets are linear. Without loss of generality, each observed variable xi**is assumed to have zero mean.**
Then, the GroupLiNGAM model is represented as

## (1) Xi =X L(J)≤L(I),I6=J Bijxj + Ei,

where eiis an external influence. All external influences ei**'s are non-Gaussian**
random variables with zero means and non-zeros variances, and independent of 2