In this section, we address the estimation of the GroupLiNGAM model from data. In the following parts, we will refer the subset of variables corresponding to S ⊆ V as xS. Also, we denote by V \ S the complementary set of V **with respect**
to S, and by xS¯ **the subset of variables corresponding to** V \ S.

3.1. Identifying exogenous variables using non-Gaussianity. **Recently, it**
has been reported that non-Gaussianity of external influences serves for directly estimating the ordering of variables from data [12] (DirectLiNGAM). **The key insight herein is that, once an exogenous variable is identified, we can remove the**
component of the exogenous variable from the other variables without violating the original ordering for the residuals when the exogenous variable is regressed on the remaining variables. Here, we describe the analogous insight still holds for sets of variables. To this end, we first need the following assumption:
Definition 1 (correlation-faithfulness). The distribution of x is said to be correlationfaithful to the generating graph if correlation and conditional correlation of xi are entailed by the graph structure, i.e., the zeros/non-zeros status of bij **, but not by** specific parameter values of bij .

This concept is motivated by the faithfulness [13]. Also, we give the definition of the exogenous set of variables as follows.

Definition 2 (exogenous set). Let the partition of the variables x be x = (xS, xS¯) such that xS and xS¯ are not empty. Then, the subset of variables xS **is said to** be exogenous against xS¯, if the corresponding partition of the the matrix B **has the**
following form:

4
$$B=\left[\begin{array}{c c}{{B_{S}}}&{{0}}\\ {{B_{\bar{S},S}}}&{{B_{\bar{S}}}}\end{array}\right].$$
Note that each variable in the exogenous set is not necessarily an exogenous variable. That is, the variables in an exogenous set may be influenced **by each** other inside of the set. Also note that the submatrix of the mixing matrix A
corresponding to BS is full-rank because the covariance matrix ΣS of xS **is also**
full-rank from the correlation-faithfulness assumption.

Now, we give two lemmas and one corollary that is the basis of the algorithm proposed in this paper.

Lemma 3. Assume that the input data x follows the GroupLiNGAM model (2),
and that the distribution of x **is correlation-faithful to the generating graph. Let** r
(S)
be the residual when xS¯ is regressed on xS for S ⊂ V : r
(S) = xS¯ − Σ
T
S,S¯Σ
−1 S xS,
where

 $\Sigma=\left[\begin{array}{ccc}\Sigma_{S}&\Sigma_{S,\bar{S}}\\ \Sigma_{S,\bar{S}}^{T}&\Sigma_{\bar{S}}\end{array}\right]$  $\sigma_{\sigma_{S},\sigma_{S}}=\sigma_{\sigma_{S}}$ Then $\sigma$ act of variables $\sigma_{S}$ is zero. 
is the covariance matrix of (xS, xS¯). Then, a set of variables xS **is exogenous if**
and only if xS **is independent of its residual** r
(S).

Proof First, assume that xS **is exogenous. Then, one can write** xS¯ = AS¯,SA
−1 S xS+
e¯
(S)
S¯**, where**

$$A={\left[\begin{array}{l l}{A_{S}}&{0}\\ {A_{S,S}}&{A_{S}}\end{array}\right]}$$
