# Reasoning Support For Risk Prediction And Prevention In Independent Living

A. Mileo, D. Merico and R. Bisiani NOMADIS Research Lab.

Dept. of Informatics, Systems and Communication University of Milan-Bicocca viale Sarca 336/14 I–20126 Milan E-mail: {alessandra.mileo, davide.merico, roberto.bisiami}@disco.unimib.it submitted 22 June 2009; revised 16 October 2009; accepted 09 December 2009

## Abstract

In recent years there has been growing interest in solutions for the delivery of clinical care for the elderly, due to the large increase in aging population. Monitoring a patient in his home environment is necessary to ensure continuity of care in home settings, but, to be useful, this activity must not be too invasive for patients and a burden for caregivers. We prototyped a system called SINDI (Secure and INDependent lIving), focused on i) collecting a limited amount of data about the person and the environment through Wireless Sensor Networks (WSN), and ii) inferring from these data enough information to support caregivers in understanding patients' well being and in predicting possible evolutions of their health. Our hierarchical logic-based model of health combines data from different sources, sensor data, tests results, common-sense knowledge and patient's clinical profile at the lower level, and correlation rules between health conditions across upper levels. The logical formalization and the reasoning process are based on Answer Set Programming.

The expressive power of this logic programming paradigm makes it possible to reason about health evolution even when the available information is incomplete and potentially incoherent, while declarativity simplifies rules specification by caregivers and allows automatic encoding of knowledge. This paper describes how these issues have been targeted in the application scenario of the SINDI system.

KEYWORDS: answer set programming, wireless sensor networks, independent living, prediction, context-awareness, knowledge representation, dependency graph.

## 1 Background And Motivations

In the last twenty years there has been a significant increase of the average age of the population in most western countries and the number of senior citizens has been and will be constantly growing. Living independently in their own homes is a key factor for these people in order to improve their quality-of-life and to reduce the costs for the community. For this reason there has been a strong development of computer technology for the delivery of clinical care outside of hospitals.

arXiv:1006.5657v1 [cs.AI] 29 Jun 2010