Reasoning Support for Risk Prediction and Prevention in Independent Living 11

| Attribute Name                                                                                                                                                                                                                                       | Domain Values                 | Description                   |
|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------|-------------------------------|
| ambientLight                                                                                                                                                                                                                                         | {dark, shadow, clear, bright} | brightness of the environment |
| ambientLightType                                                                                                                                                                                                                                     | {natural, artificial}         | nature of the light           |
| ambientHumidity                                                                                                                                                                                                                                      | {dry, medium, wet, superWet}  | humidity level                |
| ambientTemperature {cold, chilly, warm, hot, burning} temperature ambientSound {mute, mild, medium, noisy} noise level presence {yes, no} presence of a moving entity noxiousGas {yes, no} presence of noxious gas smoke {yes, no} presence of smoke |                               |                               |

Table 4. Attributes representing information about the Object entity.

| Signature                     | Domain Values                                                     | Description                                      |
|-------------------------------|-------------------------------------------------------------------|--------------------------------------------------|
| objectLight                   | {dark, shadow, clear, bright}                                     | light produced by the object                     |
| objectLightType               | {natural, artificial}                                             | nature of the light                              |
| objectTemperature {hot, cold} | meaning depends on object                                         |                                                  |
| objectSound                   | {noSound, regularSound, loudSound}                                | meaning depends on object                        |
| switch                        | {open, closed}                                                    | state of doors/windows objects                   |
| state                         | {on, off}                                                         | state of on/off devices                          |
| filteredLoad                  | {0..300}                                                          | weight measurement from mat sensors (load-cells) |
| loadVolatility                | {stable, mildlyUnstable, veryUnstable} volatility of filteredLoad |                                                  |
| waterflow                     | {yes, no}                                                         | water flowing through the object                 |

reasoning system takes as input the result of a traditional particle filter based only on radio signal strength measurements. These results are combined with a model of movement and opportunely aggregated data from infrared sensors and range finders5. Multiple preference criteria are applied in order to select the best solution according to the more reliable results of the particle filter, the best move and, finally, the most coherent position with respect to all available sensor data. Non deterministic choice is used to generate possible solutions, while the combination of optimization criteria are used to find the best candidates (see Section 4.1).

When the results of the particle filter are not available, tracking the person on the grid becomes more difficult and the space size of the solution can be huge. This happens in particular when the output of the particle filter is missing for several sequential time stamps, since the model of movement produces a high number of possibilities. In this case, values obtained by range finders and infrared sensors can