Reasoning Support for Risk Prediction and Prevention in Independent Living 15 3. *frailty*, initially evaluated through a combination of GDS test, Mini Mental test and Katz evaluation; indicators are related to some profile information such as walk speed and age, but it is very complex to evaluate frailty without the support of a caregiver; thus the evaluation based on indicators only is to be supported by additional reasoning as detailed in Section 4.3.

4. *isolation*: initially evaluated through the GDS test; the indicators are the level of social activity (number of contacts, time spent out of the house)
and the presence of affective disorders.

In order to make it possible to evaluate indicators and items in a context-aware fashion, SINDI's knolwedge model of health consists of a two-layered graph: a layer where nodes are indicators and a layer where nodes are items Indicator nodes can be connected to item nodes through arcs that represent dependencies between the differential evaluation of the indicators and the differential evaluation of the related item. One item node I1 can be connected to another item node I2 through a dependency arc that represents the influence of the differential evaluation of I1 on the differential evaluation of I2. The two layers of the graph-based representation of SINDI's knowledge model of health are illustrated in Figures 3 and 4.

SINDI's knowledge model of health allows different kinds of dependencies:
1. neg/pos: strictly negative/positive direct influence of the evaluation of a source node on the evaluation of a target node; 2. invN/invP: strictly negative/positive inverse influence of the evaluation of a source on the evaluation of a target node; 3. dir/inv: directly/inversely proportional influence of the evaluation of a source node on the evaluation of a target node; Dependencies can be specified by caregivers and are automatically mapped into ASP as follows:
link(T ype, Ind, I) *to express influence of indicator Ind on item I*
influence(T ype, I1, I2) to express influence of item I1 *on item I*2
(2)
where Type ∈ {pos, neg, invP, invN, dir, inv}.

Since we believe feedback represents the key for effective preventive interventions, an additional part of the domain knowledge of SINDI is related to the representation of admissible feedback from the system to the person monitored. Furthermore, given that each person has a different clinical history of cognitive decline and reacts in different ways to external stimuli, it is extremely important to select the most appropriate feedback according to the context.

The system can provide feedback in five different ways:

- *suggestions* according to the medical practice and the results of the prediction task;
- *alerts* when the system identifies behaviors or situations that are potentially dangerous according to the results of the prediction task;