Reasoning Support for Risk Prediction and Prevention in Independent Living 17

| Class                       | Output                  | Form            | System Action     |              |
|-----------------------------|-------------------------|-----------------|-------------------|--------------|
| Environment                 | do not walk in the dark | S, A, N         | turn lights on    |              |
| check temperature           | S, A, N                 | vocal warning   |                   |              |
| incoming call               | S, A, AA, N             | blinking lights |                   |              |
| remove clutter              | S, A, N                 | vocal warning   |                   |              |
| emergency                   | AA                      | call 911        |                   |              |
| Behaviour                   | keep active             | S, A, N, R      | propose exercises |              |
| stand up slowly             | S, A, N                 | vocal warning   |                   |              |
| make sure carpets are fixed | S                       | vocal warning   |                   |              |
| use chair to get dressed    | S                       | vocal warning   |                   |              |
| Clinical actions            | review drugs            | S               | on screen         |              |
| see a specialist            | S, R                    | on screen       |                   |              |
| (S) suggestion              | (AA) alarm              | (A) alert       | (N) notification  | (R) reminder |

Table 6. Classification of feedback outputs for fall prevention. report as output. Alarms also generate an action but unless alerts that are generated as a result of a prediction (potential risk), they are raised as a result of an evaluation
(effective risk), thus they usually need a more urgent response (e.g. a call to the caregiver when a fall is detected). In our first specification reminders do not include support on how to perform complex activities as in (Pollack et al. 2003; Boger et al. 2006). In the current release, reasoning aimed at prevention is at its early stage, and the system deals only with simple reminders according to an agenda. We are aware of the fact that logic programming techniques are promising also to solve planning problems, and we want to further investigate the potential of our formalism in guiding the person in the correct execution of daily activities. However, this is not part of the main objectives of the SINDI system, where we focus on the interpretation of incomplete sensor data aimed at predicting health evolutions exploiting a graph-based computational model of health dependencies.

Independently of how it is delivered, a feedback action can be related to:

- the environment: making the environment safer and of better quality, improving interaction with the environment, e.g. a phone call that is not acknowledged by the patient can trigger actions like reducing the volume of the TV
or blinking a light;
- the user's behavior: suggesting how to modify habits when the health assessment indicates risky conditions or providing reminders according to an agenda;
- the clinical setting: consulting a doctor, suggesting a more accurate test, reviewing a therapy, reminding medical appointments, and so on.
The combination of the results of the prediction task, domain knowledge and context-related knowledge about the person and the environment is used to determine i) *what* should be provided as feedback, ii) in *which form* and iii) *when*.

In the actual implementation of SINDI, we focused on feedback outputs related