to prevention of falls. The contents of the feedback (later referred to as feedback outputs) are identified according to the evidence-based medical knowledge derived from experimental trials and encoded as logic facts (Connell and Wolf 1997; Stuck et al. 1999; Rubenstein 2006; Ness et al. 2003).

The most appropriate form of feedback is inferred by the system on the basis of the results of reasoning: the same feedback can be provided in different forms and at different times (see Section 4.3 for details).

A feedback can be provided as soon as it is inferred or at a later time. Alarms are usually immediate, while other forms of feedback can be performed immediately or at a later time according to:

- triggers: pushing a button at a specific time or when particular conditions hold;
- user/caregiver preferences: qualitative ordering to identify more urgent/important suggestions according to the environmental/personal context setting and the form of feedback;
- static ordering: certain forms of feedback may have higher priority than others, simply because of their nature; similarly, some communication patterns can be preferred to others on the basis of clinical settings.
As an example, consider the classification of feedback outputs for fall prevention illustrated in Table 6 (Mileo and Bisiani 2009). Knowledge contained in Table 6 is represented as logic predicates of the form possible_form(*Output, F orm*) associating the content of a feedback to its possible forms. Knowledge about system's reactions is used for prevention as illustrated in Section 4.3 and it is mapped into logic predicates as follows:
- for each possible form fi ∈ F = {*s, a, aa, n, r*} for an output X use predicate possible_form(*X, f*i);
- output X triggered by some events in the form fi ∈ F is represented by predicate feedback_form(*X, f*i);
- action Z, consequence of output O triggered in form F is represented by predicate do_action(*O, F, Z*);
- the action of prompting output O triggered in form F through channel C =
{*audio, video*} at time T = {*immediate, endOfDay*} is represented by predicate do_prompt(*O, F, C, T*).

- actions observed by the system are represented by predicate action_observed(*A, T*)
where T represents a discrete time stamp and A is an action among those that can be recognised by the reasoning process.

## 4 Reasoning Support For Intelligent Monitoring

We refer to an *intelligent monitoring system* as a monitoring system that is able to support understanding and decision through the interpretation of data according to an appropriate model of the domain.

As introduced in previous sections, SINDI's inference for intelligent monitoring