is based on context interpretation, i.e. the process of reasoning about contextdependent sensor data through specific inference rules in order to provide a consistent view of the world. In pervasive environments, context-dependent data can arise from different sources; for example data may be gathered by sensors or collected from several knowledge-bases. The incompleteness and heterogeneous nature of such data stress the need for expressive reasoning techniques in order to implement effective, context-aware reasoning.

We already identified three classes of reasoning tasks performed by the SINDI
system: Context Interpretation, Health Assessment (evaluation) which uses results of Context Interpretation and Health Evolution (prediction, explanation, reaction)
based on results of Health Assessment and SINDI's model of health.

In the following subsections we illustrate SINDI's reasoning tasks for each class.

## 4.1 Context Interpretation

Data gathered by the sensors may be noisy even after aggregation, but their combination may yield a reliable interpretation. The expressive power of ASP is used to disambiguate unclear situations (e.g., where the person is) by combining heterogeneous data sources and using defaults, nondeterministic choice and preferences to select the best candidates in the space of the solutions.

The continuous measurements provided by sensors are stored in the database of SINDI (Fig. 1). In the actual implementation, tasks related to context interpretation are performed every hour. Discrete time is in seconds and sensor data are opportunely aggregated and provided when values change beyond a given threshold. As an example, the temperature is aggregated as the average temperature of a room and a new logic fact is generated whenever the temperature value changes of at least 1 degree Celsius. We are currently working on a wrapper that will make it possible to use the Clasp solver as a permanently running API that we can feed with aggregated sensor data as soon as they are available. This will make the reasoning process faster.

In order to understand how reasoning helps in the interpretation of imprecise sensor data, let us consider localization of the person in a position *X, Y* of the grid representing the home environment. SINDI's localization component is based on the intensity variations of the radio signals exchanged between nodes, filtered by a bayesian filter. Unfortunately, it is not always true that the higher the measured intensity of a signal from a node, the closest the person is to that node.

Given proximity values with a certain accuracy P at a given time T (provided as facts of the form in(*X, Y, T, P*)), the ASP program takes available sensor data that can be used to validate proximity signals and to reason about several preference criteria to identify the best solutions.

All possible positions are generated for a given time T and the optimal solutions are obtained by applying different combination of the preference criteria: when the proximity signals are available, the highest signal which is most coherent and best move is preferred. If no such position exists, then coherence is preferred to the best move criterion; finally we give up coherence if no such position exists.