For example, tele-monitoring of critical conditions (telemedicine) is becoming a common way to support medicine at-a-distance because of lower and lower costs of equipment and the savings that can be achieved. Telemedicine cannot help in prolonging Healthy Life Years (HLY) because it enters the picture when a person has already one or more critical chronic conditions. On the contrary, pervasive monitoring in the home (which has been proposed in research projects and, in a somewhat reduced form, in commercial products) has the potential of pinpointing potentially critical conditions *before* they arise.

In the last few years, many interesting systems were developed in the area of WSNs for assisted living and healthcare, among which ALARM-NET (Wood et al. 2006), SAILNet (Al-Omari and Shi 2007) and CodeBlue (Malan et al. 2004).

ALARM-NET is a wireless sensor network designed for long-term health monitoring in assisted living and residential environments. The central design goal was to adapt the behaviour of the system, including power management and privacy policy enforcement, to the individual life patterns which are analyzed and fed into the system. The system incorporates a Circadian Activity Rhythm (CAR) analysis module used in all the reasoning about the activities performed by the users. SAILNet proposes to apply the technology of WSNs as a non-obtrusive tool to monitor the activities of elders living in their apartments, focusing only on fall detection and pointing out that quick responses to these alarms are the critical requirement.

Therefore, the project puts a lot of emphasis on the availability of WSNs. CodeBlue is a wireless communications infrastructure for critical care environments. It is designed to provide routing, naming, discovery, and security for wireless medical sensors, PDAs, PCs, and other devices that may be used to monitor and treat patients in a range of medical settings. Given our application scenario, the cited projects do not fulfill all our goals.

Rather than supporting activities (Haigh and Yanco 2002) and observing behaviors (Liao et al. 2004), this paper considers a complementary view of artificial intelligence applied to home healthcare and aimed at supporting Independent Living. If we consider the majority of commercial "independent living" systems, we notice that they focus on capturing medical emergencies. This can be useful but it is not the most effective way to improve the quality of life of elderly people or to lower medical costs. A more useful goal is to prevent situations that can cause drastic changes for the worse of the quality of living, e.g., falls, constant weight loss, etc. Pervasive and continuous monitoring of an elderly can help achieving these objectives, but it is not enough. Since, sensor-based evaluation of the health state of a person cannot be as complete as a human-based evaluation can be. We believe that reliable support for prediction and prevention is possible by integrating the deployment of pervasive sensors with expressive inference capabilities that make it possible to reason about plausible evolutions of the health state of the person while considering incomplete evaluations of aspects of the health state computed from the monitoring and their inter-dependencies.

In order to address these concerns, we have designed an independent-living support system called SINDI (Secure and INDependent lIving) that includes: