When the proximity signal is not available, the same principle applies, except that we maximize the support obtained form other sensor data (namely range finder and infrared) for a given location L of the grid, rahter than maximizing the signal strength. Sensor data are represented as facts of the form sensed(*S, L, T*), where L represents the location loc(*X, Y* ), S=distance for the range finder and S=motion for the infrared.

The correspondent encoding is as follows:
time(1..207).

has_data(T) :- sense(S,X,Y,T). has_rssi(T) :- in(X,Y,T,P). invalid(loc(X,Y)) :- wall(X,Y). sensed(rssi,P,loc(X,Y),T) :- in(X,Y,T,P).

sensed(S,loc(X,Y),T) :- sense(S,X,Y,T). %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Best Move %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
location(L,T) :- sensed(rssi,P,L,T).

location(L,T) :- sensed(S,L,T).

location(L) :- location(L,T), not invalid(L).

length(L,T) :- location(N;M), dist(N,M,L,T).

dist(loc(X,Y),loc(U,V),\#abs(X-U) + \#abs(Y-V),T) :- location(loc(X,Y),T), location(loc(U,V),T-1).

distance(D,L,T) :- location(L,T), at(M,T-1), dist(L,M,D,T), location(L).

best_distance(D,T) :- D = \#min [distance(E,L,T) : location(L,T): length(E,T): E>0 = E ],
time(T;T-1).

best_movement(L,T) :- distance(D,L,T), best_distance(D,T).

## %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Best Coherence
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
is_passage(X,Y) :- passage(X,Y,R1,A1,R2,A2).

is_cell(X,Y) :- cell(X,Y,R,A). data_expected(S,loc(X,Y)) :- data_ex(S,X,Y).

ex_support(N,L) :- N = [data_expected(S,L) : sensed_type(S)], location(L,T).

p_support(L,T,C) :- C = [sensed(S,L,T) : data_expected(S,L)], location(L,T), not invalid(L).

coherence(L,T,P) :- p_support(L,T,C), P=(100*C)/N, ex_support(N,L), C>0, N>0.

coherence(L,T,C) :- p_support(L,T,C), C=0, ex_support(N,L), N>0. coherence(L,T,100) :- p_support(L,T,C), ex_support(N,L), C=0, N=0.

most_coherent_time(T,M) :- M = \#max [coherence(L,T,C) : coherence(L,T,C) = C],
time(T), perc(C), M>=0.

most_coherent(L,T) :- most_coherent_time(T,C), coherence(L,T,C).

best_coherence(L,T) :- most_coherent(L,T). %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% % Multicriteria optimization
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
criterion(1..4). criterion(1,L,T) :- location(L,T), best_movement(L,T), best_coherence(L,T). criterion(2,L,T) :- location(L,T), best_movement(L,T). criterion(3,L,T) :- location(L,T), best_coherence(L,T).