alities), ii) results of data aggregation (e.g. quality of movement) and iii) results of ad-hoc logic rules (e.g. quality of sleep).

Absolute evaluation is represented in form of logic predicates of the form:
obsInd(Ind, V, H) for indicators obsItem(I, V, H) *for items* (3)
where H is a time stamp identifying the hour associated to the inference cycle the evaluation refers to6, and value V is defined over specific ranges in the knowledge base. The current hour being processed is provided by fact hour(N), N = 0..23.

In order to highlight the advantages of using reasoning in the evaluation process, we provide an example of how inference can help in this reasoning phase. Example 1 Consider the indicator *quality of sleep* which is one of the most interesting in assessing the well being of the elderly because it can be used as a predictor of worsening conditions. Nonmonotonic reasoning based on ASP makes it possible to combine several context-dependent informations inferred by the context interpretation process to determine a consistent evaluation of the overall quality of sleep. A simplified version of the encoding used to connect consecutive reasoning cycles to determine night activity is as follows:
night :- hour(N), N<8.

night :- hour(N), N>21.

awake(T) :- not in_bed(T), time(T), localized(T), night. sleep_interrupt(T) :- in_bed(T1), awake(T), T1<T. sleep_interrupt(T) :- obsInd(S,ok,1), link(L,S,sleep), awake(T), time(T).

sleep_interrupt(T) :- obsInd(S,moderate,1), link(L,S,sleep), awake(T), time(T). back_to_bed(T) :- awake(T1), in_bed(T), T1<T, obsInd(S,mild,1), link(L,S,sleep).

back_to_bed(T) :- sleep_interrupt(T0), awake(T1), in_bed(T), T0<T1, T1<T,
link(L,S,sleep), time(T0;T1;T).

bad_sleep(T) :- in_bed(T), attribute_obj(loadVolatility,bed,N,T), N!=stable.

poss_early_awake(T) :- sleep_interrupt(T), not in_bed(T1), T<=T1, time(T1).

poss_early_awake(T) :- awake(T), obsInd(S,mild,1), link(L,S,sleep), time(T). n_early_awake(T) :- poss_early_awake(T), back_to_bed(T1), time(T1), T<T1.

The following piece of code is in charge of evaluating indicators associated to the quality of sleep:
period(N,earlynight) :- hour(N), N>21.

period(N,middlenight) :- hour(N), N<2.

period(N,latenight) :- hour(N), 2<=N, N<5.

obsInd(S,ok,0) :- link(L,S,sleep), not sleep_interrupt(T1), time(T1),
in_bed(T), T1!=T, obsInd(S,ok,1), period(N,S), hour(N),
not obsInd(S,mild,0), not obsInd(S,moderate,0),
6 Timestamp H = 0 is associated the hour being evaluated, while timestamps H > 0 refers to previous inference steps: the highest H, the oldest the hour.