We represent an absolute (available as an input) differential evaluation of item I
with predicate diff_item(*L, I, V al, T*); an inferred differential evaluation of item I is computed by the reasoning engine according to values of indicators Indi connected to I, and it is represented by the predicate diff_item_inferred(*L, I, V al, T*).

The sign of the dependency is represented by predicate infl_sign(*I, Ind, S, T*)
with S ∈ {0, −1, 1}. The sign S of infl_sign(*I, Ind, S, T*)) depends on the differential evaluation of Ind represented by predicate diff_ind(*Ind, V al, T*) and the type of link link(*T ype, Ind, I*) as illustrated in Table 7. Differential values *V al* correspond to a sign S as follows: *better* corresponds to "+", *worse* corresponds to "−"
and *equal* corresponds to "=". For sake of simplicity, in the knowledge representation framework we represent signs as numbers so that they can be multiplied by their weights for optimization: 0 represents no changes, −1 represents worsening conditions and +1 represents improvements.

The logic rules implementing this behaviour would look like the following:
to_evaluate(L,I) :- not diff_item(L,I,Val,T).

n_invariant(I) :- infl_sign(I,Ind,S,T), S!=0.

diff_item_inferred(L,I,S,T) :- to_evaluate(L,I), infl_sign(I,Ind,S,T),
not infl_sign(I,Ind1,S1,T), S1=S*(-1).

diff_item_inferred(L,I,0,T) :- to_evaluate(L,I), infl_sign(I,Ind,0,T),
not n_invariant(I).

labeled(I) :- diff_item_inferred(L,I,S,T).

to_guess(L,I) :- to_evaluate(L,I), not labeled(L,I).

Intuitively, this reasoning process could provide additional differential evaluation useful for prediction by the higher level reasoning tasks. We could make this process more precise by using weighted arcs to represent influences of indicators Indi on item I; in this way we could label item I with the sign that has the higher sum of weights. The major problem of this approach is that in the healthcare domain, the impact of a medical dependency is not static, thus weights should be computed dynamically according to the whole clinical situation. This aspect is not even clear to caregivers and we plan to investigate this issues with domain experts to find a viable solution.

We show a graphical example that illustrates the results of reasoning in a simple two-layered graph.

Example 2 Consider the dependency graph illustrated in Figure 5.

Note that the label of arcs connecting *Indicator*2 with items Itemi, i = {1, 3, 4, 5}
is not important for their differential evaluation. In fact *Indicator*2 is marked as stable (its sign is "=") thus its influence is the same according to Table 7.

Often it can be the case that the output of the evaluation phase is a partial labeling of the graph of items and related dependencies. The following reasoning process of SINDI starts from this incomplete information about health in the Health