The first aspect refers to prediction, i.e. the identification of plausible effects of certain changes in items' values on values of unlabeled items; intuitively, this is done by considering all possible consistent values for the missing information according to SINDI's logic model of dependencies between items; prediction makes it possible to act *before* major symptoms and to plan appropriate short- and longterm interventions, thus reducing risks.

The second aspect may look similar to diagnosis, but we prefer to call it Local Explanation in that it gives reasons for the differential evaluations of an item I provided as a result of the prediction task, when the inferred sign for I is the same in all solutions. It is a *local* process rather than a case-based one, in that it takes into account results of reasoning under particular clinical and environmental conditions.

The third aspect is related to the identification of those interventions (provided as direct actions performed by the system or as suggestions) that may keep health changes within safe boundaries.

In the remaining part of this section we give implementation details for each of these classes of tasks.

Prediction In order to determine all total consistent labelings of the graph resulting from the evaluation process, the inference mechanism takes into account unlabeled items and generates consistent labeling. The instance provided as input to the ASP program includes sign S for item I represented by predicate obs_label(I, S) or inferred_label(*I, S*) provided by the evaluation process, and unlabeled items to_*guess*(Ik).

Labels are obtained according to the following procedure:

$$\mathbb{T}\ I$$
$$\begin{array}{l}{{\exists~o b s\_l a b e l(I,S):}}\\ {{c o m p u t e~s i g n(I,I_{k},S^{\prime})}}\\ {{c o m p u t e~w e i g h t~W(I,I_{k})~|}}\\ {{}}\\ {{t o\_g u e s s(I_{k}):}}\\ {{c o m p u t e~t o t a l~w e i g h t}}\\ {{c o m p u t e~w i n i n g~s i g n~S_{w}}}\end{array}$$

compute sign(I, Ik, S0) for each arc(I, Ik) *as in T able* 7;
compute weight W(I, Ik) | W(*I, I*k) = 5 if ∃ obs_label(*I, S*),
compute total weight Wtot(I, Ik, S0) = Σn
_for each arc$(I,I_{k})$ as in Table 7; $W(I,I_{k})=5$ if $\exists$ obs_label$(I,S)$, $W(I,I_{k})=1$ if $\exists$ inferred_label$(I,S)$;_  $$W_{tot}(I,I_{k},S^{\prime})=\Sigma_{k=1}^{n}\ W(I,I_{k})\ |\ sign(I,I_{k},S^{\prime});$$ $$ilab(I_{k},S_{w}).\eqno(4)$$
$$\forall\ I_{k}\ |$$
compute winning sign Sw ilab(Ik, Sw).
As a result of the prediction task, the ASP logic program may yield different
solutions from which we extract:
1. guessed signs S
0for item I that are true in all possible solutions, represented by predicate ilab(*I, S*0),
2. for all other items Ig for which there are several possible guesses, we prefer the solution where each Ig is labeled with sign Sg such that the sum Σ
n g=1 Wtot(Ig, Sg) is maximized.
The following example shows results of prediction task on a small graph that has been partially labeled by the evaluation process.