SINDI does not have to deal with graphs that are potentially very large (thousands of nodes and dependencies). The complexity for the prediction task derives from the ratio of arcs with respect to nodes (the higher the number of inner arcs for a node I, the higher the number of possible influences on the value of I). Also the number of initial observations available may influence results: the higher the number of observations, the harder it could be to find a consistent colouring when observations seem to be incoherent. Our tests on some random instances with a few hundreds of dependencies (which is still an overestimation of the real setting)
showed that the connectiveness of the graph is not a problem for the ASP computation.

As for the prediction task, we summarize some results in Table 10, where time is expressed in seconds, to illustrate how reasoning can help predicting health evolutions even when few evaluations are available. The table shows that the higher the number of labeled items, the lower is the percentage of the contribution of reasoning in labeling new items. This sometimes depends on the initial labeling, e.g. how well distributed the observed items are and how much coherent are their evaluations.

In evaluating indicators, delegating part of the aggregation process to the WSN
nodes lowered the computational time by 60% for instances of medium complexity
(i.e. for a person that is active from 30 to 40 per cent of the time in a day). We believe that the integration of ASP reasoning with constraint solving techniques (Mellarkod et al. 2008) could make context interpretation from sensor data more efficient and we plan to investigate it. This of course does not include situations in which emergencies arise, since they are detected almost immediately.

## 6 Conclusions

The paper has described in detail the design of a system for supporting Independent Living. The system has not yet been fully evaluated in the field but it is working and has been tested in the laboratory with real data. Full validation of systems like SINDI is very hard because the quality of the system depends on properties that are very difficult to quantize, e.g. patient and caregiver satisfaction, increase of the Healthy Life Years period, correctness in predicting risky situations, and so on. We are building the hardware necessary for a few deployments in patient's homes and are seeking funding from various agencies for large-scale field-deployment and test.

Reasoning support to home monitoring has interesting potential developments.

Among them, we want to investigate how observations that may appear to be inconsistent with the model of health can help discovering missing dependencies and refine the model itself.

Application-wise, given the high variability among trials and studies addressing prediction and prevention issues, it is still difficult to extract a coherent picture of what leads to disability and to develop coherent prevention strategies. In this respect, our system has the potential of automatically collecting a massive amount of data in order to evaluate context-related prediction patterns and effective communication strategies for prevention.