Reasoning Support for Risk Prediction and Prevention in Independent Living 5 false positives) and adaptive (e.g., suitable for the introduction of new available information).

To devise an appropriate knowledge representation and reasoning model for SINDI, we considered the main classes of tasks we want our independent-living system to perform, namely:
- Interpretation of Context based on a logic-based context model and consisting in i) *Localization* of the person in the environment and ii) *Identification* of simple activities (opening doors/windows, sleeping, walking, etc.).

- Health Assessment based on a logic model of health and consisting in i)
Evaluation of significant aspects of the patient's quality of life (referred to as indicators) including quality of the environment, quality of movement, quality of sleep, weight, use of lights, etc., and iii) *Evaluation* of a well-defined set of health-related factors (referred to as *items*); the evaluation of each item is obtained according to the values of the indicators related to that item and the influences between each indicator and the item (see Figures 3 and 4 )1.

- Health Evolution based on the analysis of dependencies among items and consisting in i) *Prediction* of possibly-risky situations and identification of dependencies representing plausible causes, ii) *Explanation* of identified risks through common causalities and iii) *Reaction* of the system in form of predefined warnings/suggestions/actions aimed at prevention.

According to these views, there are three components of the knowledge model and three aspects in which reasoning is involved: the first one is related to the use of sensor data and common-sense reasoning for context interpretation, the second one refers to the (partial) evaluation of indicators according to the results of context interpretation and the (partial) evaluation of items according to related indicators, while the last one is related to understanding and predicting the evolution of the health state according to the dependency graph, in order to provide appropriate feedback and support clinicians' understanding.

Section 2 reviews the logical framework for knowledge representation and reasoning used in SINDI. Section 3 describes the knowledge representation model of SINDI with respect to the context and the elderly care, while Section 4 gives details about SINDI's reasoning tasks in terms of context interpretation, context-dependent evaluation and health assessment. Section 5 contains a preliminary evaluation.

## 2 The Logical Framework

The declarative logical framework we use for Knowledge Representation and Reasoning in SINDI is that of Answer Set Programming (ASP), based on the *stable*