model semantics for Logic Programs proposed by Gelfond and Lifschitz (Gelfond and Lifschitz 1988; Marek and Truszczynski 1989; Niemelä 1999).

Compared to pure statistical approaches, logic inference based on ASP is highly expressive and computationally more performant because it can deal with first-order representations, which are much richer than the propositional ones characterizing probabilistic inference. Furthermore, ASP can deal with incomplete information and common-sense reasoning using defaults. Cardinality and weight constraints together with optimization techniques are also interesting features for our application, in that they can be used to model different degrees of uncertainty (Brewka et al.

2002; Simons et al. 2002; Leone et al. 2006; Gebser et al. 2007): given the incompleteness of available knowledge, we may need to use both optimization criteria to select the best candidate solutions according to both qualitative and quantitative criteria. Declarativity also represents a desirable feature because it allows the automatic encoding of medical knowledge, thus making the system easily extensible and medically sound.

Before we describe our Knowledge Representation Model and Reasoning Algorithms, we want to recall some basic ASP definitions. In ASP a given problem is represented by a logic program whose results are given in terms of *answer sets*.

A logic program P is a finite set of rules ri of the form

$r_{i}:L_{0}\gets L_{1},...,$$L_{m},$$not$$L_{m+1},...,$$not$$L_{n}$
where Li (i = 0..n) are literals, not is a logical connective called *negation as* failure and n ≥ m ≥ 0. We define L0 = *head*(r) as the *head* of rule ri, and body(ri) = L1, . . . , Lm, not Lm+1, . . . , not Ln as the *body* of ri. Furthermore, let *body*+(ri) = {L1*, . . . , L*m} and *body*−(ri) = {not Lm+1, . . . , not Ln}. Rules ri with *head*(ri) = ∅ are called *integrity constraints*, while if *body*(ri) = ∅, we refer to ri as *a fact*.

An interpretation is represented by the set of atoms that are true in it. A *model* of a program P is an interpretation in which all rules of P are true according to the standard definition of truth in propositional logic. Apart from letting ','
stand for conjunction, this implies treating rules and default negation by not as implications and classical negation, respectively. Note that the (empty) head of an integrity constraint is false w.r.t. every interpretation, while the empty body is true w.r.t. every interpretation. Answer sets of P are particular models of P satisfying an additional stability criterion. Roughly, a set X of atoms is an answer set, if for every rule of form (1), L0 ∈ X whenever L1*, . . . , L*m belong to X and no Lm+1*, . . . , L*n belongs to X.

Formally, an *answer set* X of a program P is a minimal (in the sense of setinclusion) model of
{head(ri) ← body+(ri) | ri ∈ *P, body*−(ri) ∩ X = ∅}.

Although answer sets are usually defined on ground (i.e., variable-free) programs, the rich modeling language of ASP allows for non-ground problem encodings, where rules with variables (upper case names) are taken as a shorthand for the sets of